
#' Losses on Business Disruption and System Failures
#'
#' Operational losses from the *business disruption and system failures* of
#' the Italian bank UniCredit between 2005 and 2014. The data, which are scaled
#' by an unknown factor for anonymity reasons, have been provided by the
#' UniCredit's Operational Risk Department. More information related to these
#' data can be found in \insertCite{hambuckers2018;textual}{tukeyGH} and
#' \insertCite{bee2021a;textual}{tukeyGH}.
#'
#' @name BDSF
#' @docType data
#'
#' @format `numeric` with 152 operational losses.
#' 
#' @family data
#'
#' @references
#' \insertAllCited{}
#'
#' @keywords data
NULL



#' Losses on Clients, Products, and Business Practices
#'
#' Operational losses from the *clients, products, and business practices* of
#' the Italian bank UniCredit in 2014. The data, which are scaled by an unknown
#' factor for anonymity reasons, have been provided by the UniCredit's
#' Operational Risk Department. Losses are adjusted for inflation
#' by means of the monthly Italian consumer price index (base 100: December
#' 2013). Around one-fourth of the losses are related to financial instruments
#' and derivative products. More information related to these data can be found
#' in \insertCite{hambuckers2018;textual}{tukeyGH} and
#' \insertCite{bee2019a;textual}{tukeyGH}.
#'
#' @name CPBP2014
#' @docType data
#'
#' @format `numeric` with 583 operational losses.
#' 
#' @family data
#'
#' @references
#' \insertAllCited{}
#'
#' @keywords data
NULL



#' Losses on Execution, Delivery, and Process Management
#'
#' Operational losses from the *execution, delivery, and process management* of
#' the Italian bank UniCredit in 2014. The data, which are scaled by an unknown
#' factor for anonymity reasons, have been provided by the UniCredit's
#' Operational Risk Department. Losses are adjusted for inflation
#' by means of the monthly Italian consumer price index (base 100: December
#' 2013). Around one-fourth of the losses are related to financial instruments
#' and derivative products. More information related to these data can be found
#' in \insertCite{hambuckers2018;textual}{tukeyGH} and
#' \insertCite{bee2019a;textual}{tukeyGH}.
#'
#' @name EDPM2014
#' @docType data
#'
#' @format `numeric` with 417 operational losses.
#' 
#' @family data
#'
#' @references
#' \insertAllCited{}
#'
#' @keywords data
NULL



#' Losses on Employment Practices and Workplace Safety
#'
#' Operational losses from the *employment practices and workplace safety* of
#' the Italian bank UniCredit in 2014. The data, which are scaled by an unknown
#' factor for anonymity reasons, have been provided by the UniCredit's
#' Operational Risk Department. More information related to these data can be
#' in \insertCite{hambuckers2018;textual}{tukeyGH} and
#' \insertCite{bee2019a;textual}{tukeyGH}.
#'
#' @name EPWS2014
#' @docType data
#'
#' @format `numeric` with 97 operational losses.
#' 
#' @family data
#'
#' @references
#' \insertAllCited{}
#'
#' @keywords data
NULL




