% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EffTox.R
\name{efftox_simulate}
\alias{efftox_simulate}
\title{Run EffTox simulations}
\usage{
efftox_simulate(dat, num_sims, first_dose, true_eff, true_tox, cohort_sizes,
  ...)
}
\arguments{
\item{dat}{An instance of \code{\link{efftox_params}}, a list of EffTox
parameters. An example is yielded by \code{\link{efftox_parameters_demo}}.}

\item{num_sims}{integer, number of simulated iterations}

\item{first_dose}{integer, the dose-level to give to patient 1, e.g. 1 for
the lowest dose.}

\item{true_eff}{the true probabilities of efficacy at the doses under
investigation; a vector of numbers between 0 and 1.}

\item{true_tox}{the true probabilities of toxicity at the doses under
investigation; a vector of numbers between 0 and 1.}

\item{cohort_sizes}{a vector of integer cohort sizes. A dose decision is made
when each cohort is completed and the next cohort is treated at the
recommended dose. To conduct a trial using at most 20 patients, where dose is
re-evaluated after every second patient, use \code{rep(2, 10)}. To conduct a
trial of 8 patients where dose is re-evaluated after each single patient, use
\code{rep(1, 8)}. Cohort size need not be uniform. E.g.
\code{c(rep(1, 5), rep(3, 10))} represents a trial where the dose is
re-evaluated after each patient for the first 5 patients, and then after
every third patient for a further 30 patients.}

\item{...}{Extra parameters provided via the ellipsis are passed to
\code{stan::sampling}}
}
\value{
A list with named elements \code{recommended_dose},
\code{efficacies}, \code{toxicities}, and \code{doses_given}.
}
\description{
Run EffTox simulations for assumed true efficacy and toxicity
curves.
}
\examples{
dat <- efftox_parameters_demo()
set.seed(123)
# Let's say we want to use only 2 chains. Extra args are passed to stan
\dontrun{
sims <- efftox_simulate(dat, num_sims = 10, first_dose = 1,
                        true_eff = c(0.20, 0.40, 0.60, 0.80, 0.90),
                        true_tox = c(0.05, 0.10, 0.15, 0.20, 0.40),
                        cohort_sizes = rep(3, 13),
                        chains = 2)
table(sims$recommended_dose) / length(sims$recommended_dose)
table(unlist(sims$doses_given)) / length(unlist(sims$doses_given))
table(unlist(sims$doses_given)) / length(sims$recommended_dose)
}
# In real life, we would run thousands of iterations, not 10.
# This is an example.
}
