% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_yields.R
\name{get_yields}
\alias{get_yields}
\title{Load data from FRED}
\usage{
get_yields(
  series = "DGS10",
  na_locf = TRUE,
  percent_adjust = TRUE,
  format_out = "xts",
  ...
)
}
\arguments{
\item{series}{The series code as found on https://fred.stlouisfed.org/, see details}

\item{na_locf}{replace NA's with last observation}

\item{percent_adjust}{divide raw data by 100}

\item{format_out}{xts or tibble}

\item{...}{Additional parameters handed to quantmod::getSymbols}
}
\value{
The yields data as an xts object
}
\description{
Load data from FRED
}
\details{
The function is a wrapper for quantmod::getSymbols().

Commonly used constant-maturity yield series are:

\itemize{
\item{DGS1MO: 1-Month Treasury Constant Maturity Rate}
\item{DGS3MO: 3-Month Treasury Constant Maturity Rate}
\item{DGS6MO: 6-Month Treasury Constant Maturity Rate}
\item{DGS1: 1-Year Treasury Constant Maturity Rate}
\item{DGS2: 2-Year Treasury Constant Maturity Rate}
\item{DGS3: 3-Year Treasury Constant Maturity Rate}
\item{DGS5: 5-Year Treasury Constant Maturity Rate}
\item{DGS7: 7-Year Treasury Constant Maturity Rate}
\item{DGS10: 10-Year Treasury Constant Maturity Rate}
\item{DGS20: 20-Year Treasury Constant Maturity Rate}
\item{DGS30: 30-Year Treasury Constant Maturity Rate}
}
}
\examples{
# US 1-Month yields
yields_us_1m <- get_yields(series = "DGS1MO")
}
