% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata.R
\name{trackeRdata}
\alias{trackeRdata}
\title{Create a trackeRdata object}
\usage{
trackeRdata(dat, units = NULL, sport = NULL, session_threshold = 2,
  correct_distances = FALSE, smooth_elevation_gain = TRUE,
  from_distances = TRUE, country = NULL, mask = TRUE, lgap = 30,
  lskip = 5, m = 11, silent = FALSE)
}
\arguments{
\item{dat}{A \code{\link{data.frame}} object.}

\item{units}{The output of \code{\link{generate_units}}.}

\item{sport}{What sport does \code{dat} contain data of? Either
\code{'cycling'}, \code{'running'}, \code{'swimming'} or
\code{NULL} (default), in which case the sport is directly
extracted from the \code{dat}. See Details.}

\item{session_threshold}{The threshold in hours for the time
difference between consecutive timestamps above which they are
considered to belong to different training sessions.}

\item{correct_distances}{Logical. Should the distances be corrected
for elevation? Default is \code{FALSE}.}

\item{smooth_elevation_gain}{Logical. Should the elevation gain be
smoothed before computing elevation gain? Default
is \code{TRUE}.}

\item{from_distances}{Logical. Should the speeds be calculated from the distance recordings
instead of taken from the speed recordings directly?}

\item{country}{ISO3 country code for downloading altitude data. If
\code{NULL}, country is derived from longitude and latitude}

\item{mask}{Logical. Passed on to
\code{\link[raster]{getData}}. Should only the altitudes for
the specified \code{country} be extracted (\code{TRUE}) or also
those for the neighboring countries (\code{FALSE})?}

\item{lgap}{Time in seconds corresponding to the minimal sampling rate.}

\item{lskip}{Time in seconds between the last observation before a small break
and the first imputed speed or the last imputed speed and the first
observation after a small break.}

\item{m}{Number of imputed observations in each small break.}

\item{silent}{Logical. Should warnings be generated if any of the
sanity checks on the data are triggered?}
}
\description{
Create a trackeRdata object from a data frame with observations
being divided in separate training sessions. For breaks within a
session observations are imputed.
}
\details{
During small breaks within a session, e.g., because the recording
device was paused, observations are imputed the following way: 0
for speed, last known position for latitude, longitude and
altitude, NA or 0 power for running or cycling session,
respectively, and NA for all other variables. Distances are
(re-)calculated based on speeds after imputation.

\code{trackeRdata} assumes that all observations in \code{dat} are
from the same \code{sport}, even if \code{dat} ends up having
observations from different sessions (also depending on the value
of \code{session_threshold}.

if \code{attr(dat, 'sport')} is \code{NA} then the current
implementation of \code{trackeRdata} returns an error.

More details about the resulting \code{trackeRdata} object are
available in the package vignette, which is an up-to-date version
of Frick & Kosmidis (2017).
}
\examples{
## read raw data
filepath <- system.file('extdata/tcx/', '2013-06-08-090442.TCX', package = 'trackeR')
run0 <- readTCX(file = filepath, timezone = 'GMT')

## turn into trackeRdata object
units0 <- generate_units()
run0 <- trackeRdata(run0, units = units0)
}
\references{
Frick, H., Kosmidis, I. (2017). trackeR: Infrastructure for Running
and Cycling Data from GPS-Enabled Tracking Devices in
R. \emph{Journal of Statistical Software}, \bold{82}(7),
1--29. doi:10.18637/jss.v082.i07
}
\seealso{
\code{\link{readContainer}} for reading .tcx and .db3
    files directly into \code{trackeRdata} objects, and
    \code{\link{get_elevation_gain}} for details on the computation
    of the elevation gain.
}
