% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{plot.parameter_sensitivity}
\alias{plot.parameter_sensitivity}
\title{Plot Parameter Sensitivity Analysis}
\usage{
\method{plot}{parameter_sensitivity}(
  x,
  width = 3.5,
  height = 3.5,
  save_plot = FALSE,
  output_dir,
  y_limit_factor = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{parameter_sensitivity} object, typically from \code{parameter_sensitivity_analysis()}.}

\item{width}{The numeric width of the output plot in inches.}

\item{height}{The numeric height of the output plot in inches.}

\item{save_plot}{A logical indicating whether to save the plot to a file.}

\item{output_dir}{A character string specifying the directory for output files. Required if \code{save_plot} is TRUE.}

\item{y_limit_factor}{A numeric factor to set the upper y-axis limit as a percentage
above the threshold value (e.g., 1.10 for 10\% above). If NULL, scaling is automatic.}

\item{...}{Additional arguments (not currently used).}
}
\value{
A \code{ggplot} object representing the sensitivity plot.
}
\description{
The S3 plot method for \code{parameter_sensitivity} objects. It creates a visualization
showing how the model's performance (minimum MAE) changes across the range of a
single parameter. A threshold line is included to indicate the region of acceptable
performance.
}
