% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{show_list}
\alias{show_list}
\alias{show_block}
\alias{show_censor}
\title{Display a node or nodelist as markdown}
\usage{
show_list(nodelist, stylesheet_path = stylesheet())

show_block(nodelist, mark = FALSE, stylesheet_path = stylesheet())

show_censor(nodelist, stylesheet_path = stylesheet())
}
\arguments{
\item{nodelist}{an object of class \code{xml_nodeset} OR \code{xml_node} OR a list of
either.}

\item{stylesheet_path}{path to the XSL stylesheet}

\item{mark}{[bool] When \code{TRUE} markers (\verb{[...]}) are added to replace
nodes that come before or after the islated nodes. Defaults to \code{FALSE},
which only shows the isolated nodes in their respective blocks. Note that
the default state may cause nodes within the same block to appear adjacent
to each other.}
}
\value{
a character vector, invisibly. The result of these functions are
displayed to the screen
}
\description{
When inspecting the results of an XPath query, displaying the text often
}
\examples{
path <- system.file("extdata", "show-example.md", package = "tinkr")
y <- tinkr::yarn$new(path, sourcepos = TRUE)
y$protect_math()$protect_curly()
items <- xml2::xml_find_all(y$body, ".//md:item", tinkr::md_ns())
imgs <- xml2::xml_find_all(y$body, ".//md:image | .//node()[@curly]",
  tinkr::md_ns())
links <- xml2::xml_find_all(y$body, ".//md:link", tinkr::md_ns())
code <- xml2::xml_find_all(y$body, ".//md:code", tinkr::md_ns())
blocks <- xml2::xml_find_all(y$body, ".//md:code_block", tinkr::md_ns())

# show a list of items
show_list(links)
show_list(code)
show_list(blocks)

# show the items in their local structure
show_block(items)
show_block(links, mark = TRUE)

# show the items in the full document censored (everything but whitespace):
show_censor(imgs)

# You can also adjust the censorship parameters. There are two paramters
# available: the mark, which chooses what character you want to use to
# replace characters (default: `\u2587`); and the regex which specifies
# characters to replace (default: `[^[:space:]]`, which replaces all
# non-whitespace characters.
#
# The following will replace everything that is not a whitespace
# or punctuation character with "o" for a very ghostly document
op <- options()
options(tinkr.censor.regex = "[^[:space:][:punct:]]")
options(tinkr.censor.mark = "o")
show_censor(links)
options(tinkr.censor.regex = NULL)
options(tinkr.censor.mark = NULL)
}
\seealso{
\code{\link[=to_md_vec]{to_md_vec()}} to get a vector of these elements in isolation.
}
