% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{rbind_tigris}
\alias{rbind_tigris}
\title{Row-bind \code{tigris} Spatial objects}
\usage{
rbind_tigris(...)
}
\arguments{
\item{...}{individual (optionally names) \code{tigris} Spatial objects or a list of them}
}
\value{
one combined Spatial object
}
\description{
If multiple school district types are rbound, coerces to "sdall" and does it
}
\examples{
\dontrun{
library(sp)
library(rgeos)
library(maptools)
library(maps)
library(tigris)

me_ctys <- list_counties("me")
aw <- lapply(me_ctys$county_code[1:3], function(x) {
  area_water("Maine", x)
})
tmp <- rbind_tigris(aw)
tmp_simp <- gSimplify(tmp, tol=1/200, topologyPreserve=TRUE)
tmp_simp <- SpatialPolygonsDataFrame(tmp_simp, tmp@data)
plot(tmp_simp)
}
}
