% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legislative.R
\name{congressional_districts}
\alias{congressional_districts}
\title{Download a congressional districts shapefile into R}
\usage{
congressional_districts(cb = FALSE, resolution = "500k", year = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
cartographic boundary file.  Defaults to FALSE (the most detailed
TIGER/Line file).}

\item{resolution}{The resolution of the cartographic boundary file (if cb == TRUE).
Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}

\item{year}{the data year (defaults to 2019).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sf"} (the default) or \code{"sp"} to
request sf or sp class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
Description from the US Census Bureau (see link for source):
Congressional districts are the 435 areas from which members are elected to the U.S. House of Representatives. After the apportionment of congressional seats among the states, which is based on decennial census population counts, each state with multiple seats is responsible for establishing congressional districts for the purpose of electing representatives. Each congressional district is to be as equal in population to all other congressional districts in a state as practicable. The boundaries and numbers shown for the congressional districts are those specified in the state laws or court orders establishing the districts within each state.
}
\details{
Congressional districts for the 108th through 112th sessions were established by the states based on the result of the 2000 Census. Congressional districts for the 113th through 116th sessions were established by the states based on the result of the 2010 Census. Boundaries are effective until January of odd number years (for example, January 2015, January 2017, etc.), unless a state initiative or court ordered redistricting requires a change. All states established new congressional districts in 2011-2012, with the exception of the seven single member states (Alaska, Delaware, Montana, North Dakota, South Dakota, Vermont, and Wyoming).

The current default in tigris is the 116th Congress, which is available when \code{year = 2018} or \code{year = 2019}.  Older congressional district boundaries back to 2011 can be obtained by supplying the appropriate year.
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

cd116 <- congressional_districts(cb = TRUE, resolution = '20m')

leaflet(cd116) \%>\%
   addTiles() \%>\%
   addPolygons()
}
}
\seealso{
\url{https://www.census.gov/programs-surveys/geography/guidance/geo-areas/congressional-dist.html}

Other legislative district functions: 
\code{\link{state_legislative_districts}()},
\code{\link{voting_districts}()}
}
\concept{legislative district functions}
