% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tx_pvls_num.R
\name{tx_pvls_num}
\alias{tx_pvls_num}
\title{Determine Clients who are Virally Suppressed}
\usage{
tx_pvls_num(
  data,
  ref = NULL,
  states = NULL,
  facilities = NULL,
  status = "calculated",
  n = 1000
)
}
\arguments{
\item{data}{An NDR dataframe imported using the `read_ndr().}

\item{ref}{Date provided in ISO8601 format ("yyyy-mm-dd"). Used to
determine clients who are eligible for viral load and should have a
documented result. The default is the date of analysis.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}

\item{status}{Determines how the number of active clients is calculated.
The options are to either to use the NDR current_status_28_days column
or the derived current_status column ("calculated").}

\item{n}{the value below which viral load result is adjudged to be suppressed.}
}
\value{
tx_pvls_num
}
\description{
Generate the line-list of clients whose date of last viral load result is not
more than one year (for adults 20 years and above) and 6 months (for
pediatrics and adolescents) from the specified reference date and are virally
suppressed.
}
\examples{
tx_pvls_num(ndr_example)

# Determine clients who are virally suppressed for a state at the end of October 2021
tx_pvls_num(ndr_example,
  ref = "2021-10-31",
  states = "Arewa"
)

# Determine clients with viral load result less than 400
tx_pvls_num(ndr_example, n = 400)
}
