% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{skew_kurtosis}
\alias{skew_kurtosis}
\title{Calculate skew and kurtosis}
\usage{
skew_kurtosis(x, verbose = FALSE, se = FALSE, ...)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{verbose}{Logical. Whether or not to print messages to the console,
Default: FALSE}

\item{se}{Whether or not to return the standard errors, Default: FALSE}

\item{...}{Additional arguments to pass to and from functions.}
}
\value{
A \code{matrix} of skew and kurtosis statistics for \code{x}.
}
\description{
Calculate skew and kurtosis, standard errors for both, and the
estimates divided by two times the standard error. If this latter quantity
exceeds an absolute value of 1, the skew/kurtosis is significant. With very
large sample sizes, significant skew/kurtosis is common.
}
\examples{
skew_kurtosis(datasets::anscombe)
}
