% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ithresh_methods.R
\name{print.ithresh}
\alias{print.ithresh}
\title{Print method for objects of class "ithresh"}
\usage{
\method{print}{ithresh}(x, digits = 2, ...)
}
\arguments{
\item{x}{an object inheriting from class "ithresh", a result of a call to
\code{\link{ithresh}}.}

\item{digits}{An integer. Used for number formatting with
\code{\link[base]{format}} and \code{\link[base:Round]{signif}}.}

\item{...}{Additional optional arguments. At present no optional
arguments are used.}
}
\value{
The argument \code{x}, invisibly, as for all
  \code{\link[base]{print}} methods.
}
\description{
\code{print} method for class "ithresh".
}
\details{
Prints a matrix of the estimated threshold weights.
  Each row gives the weights for each training threshold for a given
  validation threshold.  The row and column names are the approximate
  quantile levels of the thresholds.
}
\seealso{
\code{\link{ithresh}} for threshold selection in the i.i.d. case
  based on leave-one-out cross-validation.

\code{\link{summary.ithresh}} Summarizing measures of threshold
  predictive performance.

\code{\link{plot.ithresh}} for the S3 plot method for objects of
  class \code{ithresh}.

\code{\link{predict.ithresh}} for predictive inference for the
  largest value observed in N years.
}
