% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_and_summary.R
\name{plot.stability}
\alias{plot.stability}
\title{Plot diagnostics for a stability object}
\usage{
\method{plot}{stability}(x, y, ..., prob = TRUE, top_scale = c("none",
  "excesses", "opposite"), vertical = TRUE)
}
\arguments{
\item{x}{an object of class "stability", a result of a call to
\code{\link{stability}}.}

\item{y}{Not used.}

\item{...}{Additional arguments passed on to
\code{\link[graphics]{matplot}}, \code{\link[graphics]{axis}}
and/or \code{\link[graphics]{segments}}.}

\item{prob}{A logical scalar.  If \code{TRUE} then the levels of thresholds
on the lower horizontal axis are represented by the proportion of
observations that lie below a threshold.  If \code{prob = FALSE} then the
values of the thresholds are used.}

\item{top_scale}{A character scalar.
If \code{top_scale = "none"} then no axis labels appear on the upper
horizontal axis.
If \code{top_scale = "excesses"} then the number of threshold excesses
at each threshold are indicated.
If \code{top_scale = "opposite"} then the type of threshold level
\emph{not} chosen using \code{prob} is indicated.}

\item{vertical}{A logical scalar.  Should the confidence intervals be
depicted using a vertical line for each threshold (\code{TRUE}) or by
joining up confidence limits across thresholds (\code{FALSE})?}
}
\value{
In addition to producing the plot a list of the arguments used
  by \code{\link[graphics]{matplot}}, \code{\link[graphics]{axis}} is
  returned (invisibly).
}
\description{
\code{plot} method for objects of class "stability" returned from
\code{\link{stability}}
}
\details{
Produces a simple threshold diagnostic plot based on the object
  returned from \code{\link{stability}}.
  The MLEs of the GP shape parameter $\eqn{\xi}$ and
  approximate \code{conf}\% confidence intervals
  for \eqn{\xi} are plotted against the threshold used to fit the GP model.
  This plot is used to choose a threshold above which the underlying GP
  shape parameter may be approximately constant. See Chapter 4 of
  Coles (2001).  See also the vignette "Introducing threshr".
  as described in .
  See also the vignette "Introducing threshr".
}
\examples{
u_vec_gom <- quantile(gom, probs = seq(0, 0.95, by = 0.05))
gom_stab <- stability(data = gom, u_vec = u_vec_gom)
plot(gom_stab)
}
\seealso{
\code{\link{stability}}.
}
