% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_spec.R
\name{step_bucketized_column}
\alias{step_bucketized_column}
\title{Creates bucketized columns}
\usage{
step_bucketized_column(spec, ..., boundaries)
}
\arguments{
\item{spec}{A feature specification created with \code{\link[=feature_spec]{feature_spec()}}.}

\item{...}{Comma separated list of variable names to apply the step. \link{selectors} can also be used.}

\item{boundaries}{A sorted list or tuple of floats specifying the boundaries.}
}
\value{
a \code{FeatureSpec} object.
}
\description{
Use this step to create bucketized columns from numeric columns.
}
\examples{
\dontrun{
library(tfdatasets)
data(hearts)
file <- tempfile()
writeLines(unique(hearts$thal), file)
hearts <- tensor_slices_dataset(hearts) \%>\% dataset_batch(32)

# use the formula interface
spec <- feature_spec(hearts, target ~ age) \%>\%
  step_numeric_column(age) \%>\%
  step_bucketized_column(age, boundaries = c(10, 20, 30))
spec_fit <- fit(spec)
final_dataset <- hearts \%>\% dataset_use_spec(spec_fit)
}
}
\seealso{
\link{steps} for a complete list of allowed steps.

Other Feature Spec Functions: 
\code{\link{dataset_use_spec}()},
\code{\link{feature_spec}()},
\code{\link{fit.FeatureSpec}()},
\code{\link{step_categorical_column_with_hash_bucket}()},
\code{\link{step_categorical_column_with_identity}()},
\code{\link{step_categorical_column_with_vocabulary_file}()},
\code{\link{step_categorical_column_with_vocabulary_list}()},
\code{\link{step_crossed_column}()},
\code{\link{step_embedding_column}()},
\code{\link{step_indicator_column}()},
\code{\link{step_numeric_column}()},
\code{\link{step_remove_column}()},
\code{\link{step_shared_embeddings_column}()},
\code{\link{steps}}
}
\concept{Feature Spec Functions}
