% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_f.R
\name{get.seq0}
\alias{get.seq0}
\title{Generates a Sequence from a Range of Frequency}
\usage{
get.seq0(start, length, by = 1)
}
\arguments{
\item{start}{First frequency of the sequence .}

\item{length}{Length of the sequence}

\item{by}{increment of the sequence}
}
\value{
A list of characters that represents the sequence.
}
\description{
Use it to generate a list of characters, where each element is a string representation of a frequency within the specified range.
}
\examples{
start <- f.monthly(2020,1)
sequence1 <- get.seq0(start, 24, 1) # this will be '2020M1', '2020M2', ..., '2021M12'
sequence2 <- get.seq0(start, 24, 2) # this will be '2020M1', '2020M3', ..., '2023M11'
sequence3 <- get.seq0(start, 24, 3) # this will be '2020M1', '2020M4', ..., '2025M10'

# backward:
sequence4 <- get.seq0(start, 24, -1) # this will be '2020M1', '2019M12', ..., '2018M2'

# Lists are a little different:
start_l <- f.list.string(c("A","B","C","D"), "C")
sequence5 <- get.seq0(start_l, 5, 1) # this will be 'C', 'D', 'out_item:1', ..., 'out_item:3'

}
\seealso{
\code{\link{get.seq}}
}
