% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.list.string}
\alias{f.list.string}
\title{Creates an \code{List-String} Frequency}
\usage{
f.list.string(items, value)
}
\arguments{
\item{items}{Items of the list.}

\item{value}{Current item.}
}
\value{
An object of class 'ldtf'. It is also a list with the following members:
\tabular{ll}{
\code{class} \tab Determines the class of this frequency.\cr
\code{items} \tab Determines the \code{items}.\cr
\code{value} \tab Determines the \code{value}.
}
}
\description{
This frequency is typically used for labeled data. It is generally a list, but it can be used to label observations outside this list.
}
\details{
In order to use \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} \code{"..."} (in which ... is the \code{value})
\item \strong{Class Id} \code{Ls} or \code{Ls:...} (in which ... is the semi-colon separated \code{items})
}
}
\examples{

L0 <- f.list.string(c("A","B","C","D"), "C")

L0_value_str <-  as.character(L0) # this will be 'C'.
L0_class_str <- get.class.id(L0) # this will be 'Ls:A;B;C;D'.

L_new <- as.frequency("A", "Ls:A;B;C;D")
L_new0 <- as.frequency("A", "Ls") # compared to the previous one, its items will be empty

# Don't make the following mistakes:
\donttest{
L_invalid <- try(as.frequency("E", "Ls:A;B;C;D")) # 'E' is not a member of the list
L_invalid <- try(f.list.string(c("A","B","C","D"), "E"))
}

}
