% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtnorm.R
\name{rtnorm}
\alias{rtnorm}
\title{Simulate Random Left-Truncated Normal Distribution}
\usage{
rtnorm(n, mu, sd, a)
}
\arguments{
\item{n}{Numeric scaler representing the number of observations. Must be greater than or equal to 1.}

\item{mu}{Mean value of the underlying normal random variable}

\item{sd}{Standard deviation of underlying normal random variable}

\item{a}{Numeric vector indicating the left-truncation value.}
}
\value{
Returns a vector of samples drawn from the specified distribition eqaul to length n.
}
\description{
This function is used to generate random samples from left-truncated normal distribution with specified mean and variance. Sampling is performed by
first drawing from a random uniform distribution to generate c.d.f. probabilities and then the inverse density function is applied to generate observations.
}
\details{
Note that if the mean \code{mu} is specified as a vector then the standard deviation
\code{sigma} must have the same length or be a scalar indicating that all samples have constant standard deviation.
}
\examples{
#zero truncated normal data with mean 0.5 and standard deviation 1
y_star <- rtnorm(n = 100, mu = 0.5, sd = 1, a = 0)

}
