% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{subtaxa}
\alias{subtaxa}
\title{Get subtaxa}
\usage{
subtaxa(x, subset = NULL, max_depth = NULL, include = FALSE, value = NULL, ...)
}
\arguments{
\item{x}{The object to get subtaxa for, such as a \link{taxonomy} object.}

\item{subset}{The subset of the tree to search. Can be indexes or names.}

\item{max_depth}{The number of ranks to traverse. For example, \code{max_depth = 1} returns only immediate subtaxa. By default (NULL) information for all
subtaxa is returned (i.e. subtaxa of subtaxa, etc).}

\item{include}{If \code{TRUE}, include information for each taxon in the output.}

\item{value}{Something to return instead of indexes. Must be the same length
as the number of taxa.}

\item{...}{Additional arguments.}
}
\description{
Get subtaxa indexes for each taxon or another per-taxon value. Subtaxa are
taxa contained within a taxon.
}
\examples{
# Generate example data
x <- taxonomy(c('Carnivora', 'Felidae', 'Panthera', 'Panthera leo',
                'Panthera tigris', 'Ursidae', 'Ursus', 'Ursus arctos'),
              supertaxa = c(NA, 1, 2, 3, 3, 1, 6, 7))

# The indexes of all subtaxa (with subtaxa of subtaxa, etc) for each taxon
subtaxa(x)

# The indexes of immediate subtaxa (without subtaxa of subtaxa, etc) for each taxon
subtaxa(x, max_depth = 1)

# Return something other than index
subtaxa(x, value = tax_name(x))

# Include each taxon with its subtaxa
subtaxa(x, value = tax_name(x), include = TRUE)

# Only return data for some taxa (faster than subsetting the whole result)
subtaxa(x, subset = 3)

}
\seealso{
Other taxonomy functions: 
\code{\link{internodes}()},
\code{\link{leaves}()},
\code{\link{roots}()},
\code{\link{stems}()},
\code{\link{supertaxa}()}

Other subtaxa functions: 
\code{\link{n_subtaxa}()}
}
\concept{subtaxa functions}
\concept{taxonomy functions}
