% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_feature_importance.R
\name{plot.feature_importance_explainer}
\alias{plot.feature_importance_explainer}
\title{Plots Feature Importance}
\usage{
\method{plot}{feature_importance_explainer}(
  x,
  ...,
  max_vars = NULL,
  show_boxplots = TRUE,
  bar_width = 10,
  desc_sorting = TRUE,
  title = "Feature Importance",
  subtitle = NULL
)
}
\arguments{
\item{x}{a feature importance explainer produced with the \code{feature_importance()} function}

\item{...}{other explainers that shall be plotted together}

\item{max_vars}{maximum number of variables that shall be presented for for each model.
By default \code{NULL} what means all variables}

\item{show_boxplots}{logical if \code{TRUE} (default) boxplot will be plotted to show permutation data.}

\item{bar_width}{width of bars. By default \code{10}}

\item{desc_sorting}{logical. Should the bars be sorted descending? By default TRUE}

\item{title}{the plot's title, by default \code{'Feature Importance'}}

\item{subtitle}{the plot's subtitle. By default - \code{NULL}, which means
the subtitle will be 'created for the XXX model', where XXX is the label of explainer(s)}
}
\value{
a \code{ggplot2} object
}
\description{
This function plots variable importance calculated as changes in the loss function after variable drops.
It uses output from \code{feature_importance} function that corresponds to
permutation based measure of variable importance.
Variables are sorted in the same order in all panels.
The order depends on the average drop out loss.
In different panels variable contributions may not look like sorted if variable
importance is different in different in different models.
}
\details{
Find more details in the \href{https://ema.drwhy.ai/featureImportance.html}{Feature Importance Chapter}.
}
\examples{
\donttest{
library(survex)
library(randomForestSRC)
library(survival)

model <- rfsrc(Surv(time, status) ~., data = veteran)
explainer <- explain(model)

mp <- model_parts(explainer, loss = loss_one_minus_c_index, output_type = "risk")
plot(mp)
}
}
\references{
Explanatory Model Analysis. Explore, Explain, and Examine Predictive Models. \url{https://ema.drwhy.ai/}
}
