% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survHE-package.R
\docType{package}
\name{survHE-package}
\alias{survHE-package}
\alias{survHE}
\title{Survival Analysis in Health Economic Evaluation}
\description{
Contains a suite of functions to perform survival analysis with the aim of
aiding in health economic modelling (extrapolation, model checking and PSA)
}
\details{
\tabular{ll}{ Package: \tab survHE\cr Type: \tab Package\cr Version: \tab
1.1.2\cr Date: \tab 2021-02-08\cr License: \tab GPL2 \cr LazyLoad: \tab
yes\cr } Contains a suite of functions to perform survival analysis with the
aim of aiding in health economic modelling (extrapolation, model checking
and PSA)
}
\examples{
\dontrun{ 
# Loads some survival data
data(bc)
# Fits a parametric model
m <- fit.models(formula=Surv(recyrs,censrec)~group,data=bc,
    distr="exp",method="mle")
# Print output in tabular format
print(m)
# Visualise output in terms of survival curves
plot(m)
}
}
\references{
G Baio (2019). survHE: Survival analysis for health economic evaluation 
and cost-effectiveness modelling. Journal of Statistical Software (2020). vol 95,
14, 1-47. <doi:10.18637/jss.v095.i14>
}
\author{
Gianluca Baio

Maintainer: Gianluca Baio
}
\keyword{Economic}
\keyword{Evaluation}
\keyword{Health}
\keyword{Modelling}
\keyword{Survival}
