% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AWKMT2.R
\name{AWKMT2}
\alias{AWKMT2}
\title{Adaptively Weighted Kaplan-Meier Tests}
\usage{
AWKMT2(indata, tau, c_first=0, c_last=4, c_by=0.1, method="permutation",
       nmethod=10000, seed=1, v1=TRUE, v2=TRUE, test="1_side")
}
\arguments{
\item{indata}{A data matrix (data frame). The 1st column is time-to-event variable, the 2nd column is event indicator (1=event, 0=censor), and the 3rd column is the treatment indicator (1=treat, 0=control). No missing values are allowed in this data matrix.}

\item{tau}{A numeric value to specify the time interval of interest. The end of study time will be a general choice.}

\item{c_first}{A first number in range to specify the search area of "c" for the versatile tests by Uno et al. (2015). Default is \code{0}.}

\item{c_last}{A last number in range to specify the search area of "c" for the versatile tests by Uno et al. (2015). Default is \code{4}.}

\item{c_by}{A number to specify the search area of "c" for the versatile tests by Uno et al. (2015). Default is \code{0.1}.}

\item{method}{A name of the resampling method. It supports \code{"permutation"} (default) and \code{"perturbation"}.}

\item{nmethod}{A number of iterations for the resampling. Recommended to specify at least \code{10000} (default) or larger.}

\item{seed}{An integer value, used for the random number generation in the resampling procedures. Default is \code{1}.}

\item{v1}{Choice of the test statistic. When \code{TRUE} (default), v1 proposed by Uno et al. (2015) is used as a test statistic.}

\item{v2}{Choice of the test statistic. When \code{TRUE} (default), v2 proposed by Uno et al. (2015) is used as a test statistic.}

\item{test}{Specify \code{"1_side"} for the one-sided test where the alternative hypothesis is that treatment group is superior to control group with respect to survival.
Specify \code{"2_side"} for the two-sided test where the alternative hypothesis is that treatment group is not equal to control group with respect to survival.
Default is \code{"1_side"}.}
}
\value{
A list with components:

\item{resampling_method}{The resampling method.}

\item{crude_pvalue_T1_1_side}{The one-sided crude p-value of the test based on v1 in Uno et al. (2015).}

\item{crude_pvalue_T2_1_side}{The one-sided crude p-value of the test based on v2 in Uno et al. (2015).}

\item{crude_pvalue_T1_2_side}{The two-sided crude p-value of the test based on v1 in Uno et al. (2015).}

\item{crude_pvalue_T2_2_side}{The two-sided crude p-value of the test based on v2 in Uno et al. (2015).}

\item{bona_fide_pvalue_T1_1_side}{The one-sided bona-fide p-value of the test based on v1 in Uno et al. (2015).}

\item{bona_fide_pvalue_T2_1_side}{The one-sided bona-fide p-value of the test based on v2 in Uno et al. (2015).}

\item{bona_fide_pvalue_T1_2_side}{The two-sided bona-fide p-value of the test based on v1 in Uno et al. (2015).}

\item{bona_fide_pvalue_T2_2_side}{The two-sided bona-fide p-value of the test based on v2 in Uno et al. (2015).}
}
\description{
Performs the two-sample tests based on adaptively weighted differences between two Kaplan-Meier curves proposed by Uno, Tian, Claggett and Wei (2015).
}
\examples{
 D        = survival::pbc[1:312, c(2,3,4)] #The pbc data from 'survival' package
 D$status = as.numeric(D$status==2)
 D$trt    = as.numeric(D$trt==2)
 names(D) = c("time", "status", "arm")
 tau      = max(D[D[,2]==1,1])
 nmethod  = 10 #Recommended to specify at least 10000 (default) or larger.

 a = AWKMT2(indata=D, tau=tau, c_first=0, c_last=4, c_by=0.1, method="permutation",
            nmethod=nmethod, seed=1, v1=TRUE, v2=TRUE, test="1_side")
 print(a)

}
\references{
Uno H, Tian L, Claggett B, Wei LJ. A versatile test for equality of two survival functions based on weighted differences of Kaplan-Meier curves.
 Statistics in Medicine 2015, 34, 3680-3695.
}
\seealso{
survival
}

