% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_functions.R
\name{nowacki_beam}
\alias{nowacki_beam}
\title{Test function: The Nowacki Beam}
\usage{
nowacki_beam(x, g = c(5, 240, 120, 10, 2), l = 1500, F = 5000,
  E = 216620, G = 86650, v = 0.27, box = data.frame(b = c(10, 50),
  h = c(20, 250)))
}
\arguments{
\item{x}{vector of length 2 correspon the normalized beath and height of the
beam}

\item{g}{vector of lenght 5 containing the upper limits of each constraint}

\item{l}{numeric length of the beam}

\item{F}{numeric force applied at the beam tip}

\item{E}{numeric elastic longitudinal moduli}

\item{G}{numeric elastic transversal moduli}

\item{v}{numeric poison ratio}

\item{box}{data.frame structure containing the upper and lower limits for
\code{b} and \code{h}}
}
\value{
vector of objective and constrain responses
}
\description{
This function is a variation of the classic multi-objective optimization
problem (NOWACKI, 1980). In this problem the aim is to design a tip loaded
cantilever eam for minimum cross-sectional aera and lowest bending stress
subject to a number of constraints.
}
\examples{
nowacki_beam(c(0,0))
nowacki_beam(c(1,1))
}
\references{
Forrester, A., Sobester, A., & Keane, A. (2008).
  \emph{Engineering design via surrogate modelling: a practical guide.} John
  Wiley & Sons.
}
