% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_extract_bound.R
\name{stri_extract_all_boundaries}
\alias{stri_extract_all_boundaries}
\alias{stri_extract_last_boundaries}
\alias{stri_extract_first_boundaries}
\alias{stri_extract_all_words}
\alias{stri_extract_first_words}
\alias{stri_extract_last_words}
\title{Extract Data Between Text Boundaries}
\usage{
stri_extract_all_boundaries(str, simplify = FALSE,
  omit_no_match = FALSE, ..., opts_brkiter = NULL)

stri_extract_last_boundaries(str, ..., opts_brkiter = NULL)

stri_extract_first_boundaries(str, ..., opts_brkiter = NULL)

stri_extract_all_words(str, simplify = FALSE, omit_no_match = FALSE,
  locale = NULL)

stri_extract_first_words(str, locale = NULL)

stri_extract_last_words(str, locale = NULL)
}
\arguments{
\item{str}{character vector or an object coercible to}

\item{simplify}{single logical value;
if \code{TRUE} or \code{NA}, then a character matrix is returned;
otherwise (the default), a list of character vectors is given, see Value}

\item{omit_no_match}{single logical value; if \code{FALSE},
then a missing value will indicate that there are no words}

\item{...}{additional settings for \code{opts_brkiter}}

\item{opts_brkiter}{a named list with \pkg{ICU} BreakIterator's settings,
see \code{\link{stri_opts_brkiter}};
\code{NULL} for the default break iterator, i.e., \code{line_break}}

\item{locale}{\code{NULL} or \code{""} for text boundary analysis following
the conventions of the default locale, or a single string with
locale identifier, see \link{stringi-locale}}
}
\value{
For \code{stri_extract_all_*},
if \code{simplify=FALSE} (the default), then a
 list of character vectors is returned. Each string consists of
a separate word. In case of \code{omit_no_match=FALSE} and
if there are no words or if a string is missing,
a single \code{NA} is provided on output.

Otherwise, \code{\link{stri_list2matrix}} with \code{byrow=TRUE} argument
is called on the resulting object.
In such a case, a character matrix with \code{length(str)} rows
is returned. Note that \code{\link{stri_list2matrix}}'s \code{fill} argument
is set to an empty string and \code{NA},
for \code{simplify} \code{TRUE} and \code{NA}, respectively.

For \code{stri_extract_first_*} and \code{stri_extract_last_*},
a character vector is returned.
A \code{NA} element indicates a no-match.
}
\description{
These functions extract data between text boundaries.
}
\details{
Vectorized over \code{str}.

For more information on text boundary analysis
performed by \pkg{ICU}'s \code{BreakIterator}, see
\link{stringi-search-boundaries}.

In case of \code{stri_extract_*_words},
just like in \code{\link{stri_count_words}},
\pkg{ICU}'s word \code{BreakIterator} iterator is used
to locate the word boundaries, and all non-word characters
(\code{UBRK_WORD_NONE} rule status) are ignored.
}
\examples{
stri_extract_all_words("stringi: THE string processing package 123.48...")

}
\seealso{
Other search_extract: \code{\link{stri_extract_all}},
  \code{\link{stri_match_all}},
  \code{\link{stringi-search}}

Other locale_sensitive: \code{\link{\%s<\%}},
  \code{\link{stri_compare}},
  \code{\link{stri_count_boundaries}},
  \code{\link{stri_duplicated}},
  \code{\link{stri_enc_detect2}},
  \code{\link{stri_locate_all_boundaries}},
  \code{\link{stri_opts_collator}},
  \code{\link{stri_order}}, \code{\link{stri_sort}},
  \code{\link{stri_split_boundaries}},
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_unique}}, \code{\link{stri_wrap}},
  \code{\link{stringi-locale}},
  \code{\link{stringi-search-boundaries}},
  \code{\link{stringi-search-coll}}

Other text_boundaries: \code{\link{stri_count_boundaries}},
  \code{\link{stri_locate_all_boundaries}},
  \code{\link{stri_opts_brkiter}},
  \code{\link{stri_split_boundaries}},
  \code{\link{stri_split_lines}},
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_wrap}},
  \code{\link{stringi-search-boundaries}},
  \code{\link{stringi-search}}
}
\concept{locale_sensitive}
\concept{search_extract}
\concept{text_boundaries}
