% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_circle.R
\name{w_circle}
\alias{w_circle}
\title{Create matrix with circular weight pattern}
\usage{
w_circle(k)
}
\arguments{
\item{k}{Neighborhood size around focal cell. Must be an odd number. For example, \code{k=3} implies a 3*3 neighborhood.}
}
\value{
A \code{matrix} with a circular pattern.
}
\description{
Creates a \code{matrix} with where a circular pattern is filled with values of \code{1} and the remaining cells are filled with values of \code{0} (see Examples).
}
\examples{
m = w_circle(3)
image(m, asp = 1, axes = FALSE)
m = w_circle(5)
image(m, asp = 1, axes = FALSE)
m = w_circle(15)
image(m, asp = 1, axes = FALSE)
m = w_circle(35)
image(m, asp = 1, axes = FALSE)
m = w_circle(91)
image(m, asp = 1, axes = FALSE)
m = w_circle(151)
image(m, asp = 1, axes = FALSE)

}
