% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run-structure.R
\name{runStructure}
\alias{runStructure}
\title{Run STRUCTURE in current path}
\usage{
runStructure(path_to_structure, input_file, main_params, extra_params,
  out_prefix, n_K, n_replicates, n_cores)
}
\arguments{
\item{path_to_structure}{path to structure binary executable (ie. /usr/bin/structure)}

\item{input_file}{file name of input data}

\item{main_params}{file name of mainparams file for STRUCTURE}

\item{extra_params}{file name of extraparams file for STRUCTURE}

\item{out_prefix}{prefix path/name for logging}

\item{n_K}{number of assumed populations to try}

\item{n_replicates}{number of replicates}

\item{n_cores}{number of cores}
}
\description{
Run STRUCTURE in current path
}
\note{
Set RANDOMIZE = 0 in main params file to avoid using same seed. Haven't tested
on Windows.
}
\examples{
\dontrun{
input_file <- system.file("inst/extdata/microsat_testfiles", "locprior.str", package = "starmie")
main_params <- system.file("inst/extdata/microsat_testfiles", "mainparams", package = "starmie")
extra_params <-  system.file("inst/extdata/microsat_testfiles", "extraparams", package = "starmie")
runStructure("structure", input_file, main_params, extra_params, "test", 5, 2, 2)
}
}

