% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grtslin.R
\name{grtslin}
\alias{grtslin}
\title{Select a Generalized Random-Tesselation Stratified (GRTS) Sample of a Linear Resource}
\usage{
grtslin(linframe, samplesize = 100, SiteBegin = 1, shift.grid = TRUE,
  startlev = NULL, maxlev = 1)
}
\arguments{
\item{linframe}{The sf object containing attributes: id, mdcaty, and mdm.}

\item{samplesize}{Number of points to select in the sample.  The default is
100.}

\item{SiteBegin}{First number to start siteID numbering.  The default is 1.}

\item{shift.grid}{Option to randomly shift the hierarchical grid.  The
default is TRUE.}

\item{startlev}{Initial number of hierarchical levels to use for the GRTS
grid, which must be less than or equal to maxlev (if maxlev is specified)
and cannot be greater than 11.  The default is NULL.}

\item{maxlev}{Maximum number of hierarchical levels to use for the GRTS
grid, which cannot be greater than 11.  The default is 11.}
}
\value{
Data frame of sample points containing: siteID, id, x, y, mdcaty,
  and weight.
}
\description{
This function select a GRTS sample of a linear resource.  The function uses
hierarchical randomization to ensure that the sample will include no more
than one point per cell and then picks a point in selected cells.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{numLevels}}{determines the number of levels for hierarchical
      randomization}
    \item{\code{constructAddr}}{constructs the hierarchical address for
      sample points}
    \item{\code{ranho}}{constructs the randomized hierarchical address for
      sample points}
    \item{\code{pickGridCells}}{selects grid cells that get a sample point}
    \item{\code{insideLinearGridCell}}{determines feature ID value and
      clipped linestring length for each feature contained in a selected grid
      cell}
    \item{\code{\link{selectFeatureID}}}{identifies a feature ID from which
      to select a sample point}
    \item{\code{pickSamplePoints}}{selects sample points from an sf object}
  }
}

\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
 Tony Olsen \email{Olsen.Tony@epa.gov}\cr
}
\keyword{survey}
