% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numLevels.R
\name{numLevels}
\alias{numLevels}
\title{Determine the Number of Levels for Hierarchical Randomization for a
Generalized Random-Tesselation Stratified (GRTS) Survey Design}
\usage{
numLevels(samplesize, shift.grid, startlev, maxlev, sfobject)
}
\arguments{
\item{samplesize}{The desired smaple size.}

\item{shift.grid}{Logical value indicating whether the GRTS grid should be
randomly shifted.}

\item{startlev}{The initial number of levels for the GRTS grid.}

\item{maxlev}{The maximum number of levels for the GRTS grid.}

\item{sfobject}{The sf object containing the survey frame.}
}
\value{
A list containing the number of levels, x-coordinates, y-coordinates,
 x-axis grid cell dimension, y-axis grid cell dimension, cell total weights,
 and sampling interval.
}
\description{
This function determine the bumber of levels of hierarchical randomization
 for a GRTS survey design.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{\link{cellWeight}}}{calculates total inclusion probability
      for each cell in a grid}
  }
}

\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\keyword{survey}
