% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbcframe.R
\name{sbcframe}
\alias{sbcframe}
\title{Calculate Spatial Balance Grid Cell Extent and Proportions for a Sample Frame}
\usage{
sbcframe(shapefilename = NULL, spframe = NULL, nrows = 5,
  dxdy = TRUE)
}
\arguments{
\item{shapefilename}{Name of the input shapefile.  If shapefilename equals
NULL, then the shapefile or shapefiles in the working directory are used.
The default is NULL.}

\item{spframe}{An sp package object of class SpatialPointsDataFrame,
SpatialLinesDataFrame, or SpatialPolygonsDataFrame that contains the
survey design frame.  The default is NULL.}

\item{nrows}{Number of rows (and columns) for the grid of cells.  The
default is 5.}

\item{dxdy}{Indicator for equal x-coordinate and y-coordinate grid cell
increments, where TRUE means the increments are equal and FALSE means the
increments are not equal.  The default is TRUE.}
}
\value{
List containing the following components:
  \describe{
    \item{extent}{the frame extent for each grid cell}
    \item{prop}{the frame proportion for each grid cell}
    \item{xmin}{the grid x-coordinate minimum value}
    \item{xmax}{the grid x-coordinate maximum value}
    \item{ymin}{the grid y-coordinate minimum value}
    \item{ymax}{the grid y-coordinate maximum value}
    \item{dx}{the grid cell x-coordinate increment value}
    \item{dy}{the grid cell y-coordinate increment value}
    \item{xc}{the vector of grid cell x-coordinates}
    \item{yc}{the vector of grid cell y-coordinates}
  }
}
\description{
This function calculates spatial balance grid cell extent and proportions
for the sample frame.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{readShapeFile}}{C function to read a single shapefile
      or multiple shapefiles}
    \item{\code{readShapeFilePts}}{C function to read the shp file of
      a point shapefile and return a data frame containing the x-coordinates
      and y-coordinates for elements in the frame}
    \item{\code{\link{cell.wt}}}{calculates number of points in a cell for a
      points object}
    \item{\code{insideLinearGridCell}}{C function to determine ID
      value and clipped polyline length for shapefile records contained in
      the selected grid cells}
    \item{\code{insideAreaGridCell}}{C function to determine ID value
      and clipped polygon area for shapefile records contained in the
      selected grid cells}
  }
}

\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
