\name{transFun}
\alias{transFun}

\title{Parameter Transformation and Backtransformation

}
\description{Enables the transformation and backtransformation of parameters. 
This is widely considered advantageous during parameter estimation as the parameter space in the transformed is well-behaved, e.g. with normally distributed posteriors.

}
\usage{
transFun(par.vec, trans.L)
}

\arguments{
\item{par.vec}{Vector of \code{n} model parameters 

}
\item{trans.L}{list of \code{n} transformation/backtransformation operators, transformation and backtransformatio rules have to be antonyms and position in vector has to coincide with that in \code{par.vec}

}

}
\details{
Transformation rules are:\deqn{log10 \alpha_i,log10 n_i-1,log10 Ks,log10 \omega,log10 Ksc,and log10 Ksnc }

}
\value{ 
\item{p.transformed}{Returns transformed parameters as specificef by trans.L}

}

\author{
Tobias KD Weber
}
\note{ The function is used to transform the parameter space and enabling optimisation or MCMC sampling to be more efficient.

}
\examples{
# van Genuchten-Mualem Model parameters
parL <- list("p" = c("thr"= 0.05, "ths" = 0.45, "alf1" = 0.01, "n" = 2, "Ks" = 100, "tau" = .5),
"psel" = c(1, 1, 0, 1, 1, 1),
"plo" = c(0.001 , 0.2, 0.001, 1.1, 1, -2),
"pup" = c(0.3, 0.95, 1, 10, 1e4, 10)
 )
# Two lists, one with function to transform, the other to back-transform model parameters
ptransfit <- c(function(x)x, function(x)x,log10,function(x)log10(x-1),log10, function(x)x)
pretransfit <- c(function(x)x, function(x)x,function(x)10^x, 
function(x)10^x+1,function(x)10^x,function(x)x)
# Transform
p_trans <- transFun(parL$p, ptransfit)
} 
\keyword{ ~transform}
