% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_def.R
\name{plot_def}
\alias{plot_def}
\title{Default method of plotting the clustering results}
\usage{
plot_def(
  result,
  cluster = "all",
  hotspot = TRUE,
  noise = FALSE,
  ignition = TRUE,
  from = NULL,
  to = NULL,
  bg = NULL
)
}
\arguments{
\item{result}{\code{spotoroo} object. A result of a call to \code{\link[=hotspot_cluster]{hotspot_cluster()}}.}

\item{cluster}{Character/Integer. If "all", plot all clusters. If an integer
vector is given, plot corresponding clusters.}

\item{hotspot}{Logical. If \code{TRUE}, plot the hot spots.}

\item{noise}{Logical. If \code{TRUE}, plot the noise points.}

\item{ignition}{Logical. If \code{TRUE}, plot the ignition points.}

\item{from}{\strong{OPTIONAL}. Date/Datetime/Numeric. Start time. The data type
needs to be the same as the provided
observed time.}

\item{to}{\strong{OPTIONAL}. Date/Datetime/Numeric. End time. The data type
needs to be the same as the provided observed time.}

\item{bg}{\strong{OPTIONAL}. \code{ggplot} object. If specified, plot onto
this object.}
}
\value{
A \code{ggplot} object. The plot of the clustering results.
}
\description{
This function plots the clustering result spatially as a scatter plot.
}
\examples{
\donttest{

  # Time consuming functions (>5 seconds)


  # Get clustering results
  result <- hotspot_cluster(hotspots,
                          lon = "lon",
                          lat = "lat",
                          obsTime = "obsTime",
                          activeTime = 24,
                          adjDist = 3000,
                          minPts = 4,
                          minTime = 3,
                          ignitionCenter = "mean",
                          timeUnit = "h",
                          timeStep = 1)

  # Plot a subset of clusters
  plot_def(result, cluster = 1:3)

  # Plot all clusters
  plot_def(result, cluster = "all")
}


}
