% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spar.R
\name{as_spar.spork}
\alias{as_spar.spork}
\title{Parse Spork}
\usage{
\method{as_spar}{spork}(x, ...)
}
\arguments{
\item{x}{length-one character using spork syntax}

\item{...}{ignored arguments}
}
\value{
spar (character vector)
}
\description{
Parses spork.  Converts length-one character
to vector of tokens.  Explicit tokens include
\code{*._^} and any of these escaped with
backslash, e.g. \code{'\\*'}.
Backslash-n is an explicit token (\code{'\\n'}).
One or more consecutive whitespace characters are a single token,
as are one or more consecutive octothorpes (\code{#}).
Any string of characters delimited by
one or more of the above is implicitly
a token as well.
}
\examples{
as_spar(as_spork('one joule (Omega) ~ 1 kg*m^2./s^2'))
}
\seealso{
Other spar: \code{\link{as_plotmath.spar}},
  \code{\link{as_spar}}

Other spork: \code{\link{[.spork}}, \code{\link{[[.spork}},
  \code{\link{as.list.spork}}, \code{\link{as.png.spork}},
  \code{\link{as_latex.spork}},
  \code{\link{as_plotmath.spork}},
  \code{\link{as_previews.spork}},
  \code{\link{as_spork.character}},
  \code{\link{as_spork.factor}},
  \code{\link{as_spork.spork}}, \code{\link{as_spork}},
  \code{\link{ggplot.spork}}
}
\concept{spar}
\concept{spork}
\keyword{manip}
