% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhc_sampling.R
\name{scale_lhc_sample}
\alias{scale_lhc_sample}
\title{Scale the LHC design to be the range explored for each parameter}
\usage{
scale_lhc_sample(PARAMETERS, PMIN, PMAX, PINC, NUMSAMPLES, design)
}
\arguments{
\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{PMIN}{Array containing the minimum value that should be used for
each parameter. Sets a lower bound on sampling space}

\item{PMAX}{Array containing the maximum value that should be used for
each parameter. Sets an upper bound on sampling space}

\item{PINC}{Array containing the increment value that should be applied
for each parameter. For example, a parameter could have a minimum value
of 10, and maximum value of 100, and be incremented by 10.}

\item{NUMSAMPLES}{The number of parameter subsets to generate}

\item{design}{The generated lhc design, all values between 0 and 1}
}
\value{
Rescaled design in the required ranges
}
\description{
As the lhc design is scaled between 0 and 1, this method rescales the
sample, putting the sampled value within the range specified for that
parameter
}
