% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_clustering_kmeans.R, R/ml_model_kmeans.R
\name{ml_kmeans}
\alias{ml_kmeans}
\alias{ml_compute_cost}
\alias{ml_compute_silhouette_measure}
\title{Spark ML -- K-Means Clustering}
\usage{
ml_kmeans(
  x,
  formula = NULL,
  k = 2,
  max_iter = 20,
  tol = 1e-04,
  init_steps = 2,
  init_mode = "k-means||",
  seed = NULL,
  features_col = "features",
  prediction_col = "prediction",
  uid = random_string("kmeans_"),
  ...
)

ml_compute_cost(model, dataset)

ml_compute_silhouette_measure(
  model,
  dataset,
  distance_measure = c("squaredEuclidean", "cosine")
)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{formula}{Used when \code{x} is a \code{tbl_spark}. R formula as a character string or a formula. This is used to transform the input dataframe before fitting, see \link{ft_r_formula} for details.}

\item{k}{The number of clusters to create}

\item{max_iter}{The maximum number of iterations to use.}

\item{tol}{Param for the convergence tolerance for iterative algorithms.}

\item{init_steps}{Number of steps for the k-means|| initialization mode. This is an advanced setting -- the default of 2 is almost always enough. Must be > 0. Default: 2.}

\item{init_mode}{Initialization algorithm. This can be either "random" to choose random points as initial cluster centers, or "k-means||" to use a parallel variant of k-means++ (Bahmani et al., Scalable K-Means++, VLDB 2012). Default: k-means||.}

\item{seed}{A random seed. Set this value if you need your results to be
reproducible across repeated calls.}

\item{features_col}{Features column name, as a length-one character vector. The column should be single vector column of numeric values. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{prediction_col}{Prediction column name.}

\item{uid}{A character string used to uniquely identify the ML estimator.}

\item{...}{Optional arguments, see Details.
#' @return The object returned depends on the class of \code{x}. If it is a
\code{spark_connection}, the function returns a \code{ml_estimator} object. If
it is a \code{ml_pipeline}, it will return a pipeline with the predictor
appended to it. If a \code{tbl_spark}, it will return a \code{tbl_spark} with
the predictions added to it.}

\item{model}{A fitted K-means model returned by \code{ml_kmeans()}}

\item{dataset}{Dataset on which to calculate K-means cost}

\item{distance_measure}{Distance measure to apply when computing the Silhouette measure.}
}
\value{
\code{ml_compute_cost()} returns the K-means cost (sum of
  squared distances of points to their nearest center) for the model
  on the given data.

\code{ml_compute_silhouette_measure()} returns the Silhouette measure
  of the clustering on the given data.
}
\description{
K-means clustering with support for k-means|| initialization proposed by Bahmani et al.
  Using `ml_kmeans()` with the formula interface requires Spark 2.0+.
}
\examples{
\dontrun{
sc <- spark_connect(master = "local")
iris_tbl <- sdf_copy_to(sc, iris, name = "iris_tbl", overwrite = TRUE)
ml_kmeans(iris_tbl, Species ~ .)
}

}
