/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.RelationalGroupedDataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$;
import org.apache.spark.sql.expressions.Aggregator;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;
import sparklyr.BoundedPriorityQueue;
import sparklyr.SamplingUtils;
import sparklyr.SamplingUtils$;
import sparklyr.StratifiedSamplingUtils$;

public final class StratifiedSamplingUtils$ {
    public static StratifiedSamplingUtils$ MODULE$;

    static {
        new StratifiedSamplingUtils$();
    }

    public RDD<Row> sampleWithoutReplacement(Dataset<Row> df, Seq<String> groupVars, String weightColumn, int k, long seed) {
        StructType schema = df.schema();
        RelationalGroupedDataset groups = df.groupBy((Seq)groupVars.map((Function1 & Serializable & scala.Serializable)x -> new Column(x), Seq$.MODULE$.canBuildFrom()));
        Set groupCols = (Set)Predef$.MODULE$.Set().apply(groupVars);
        Aggregator<Row, BoundedPriorityQueue<SamplingUtils.Sample>, BoundedPriorityQueue<SamplingUtils.Sample>> sampleAgg = this.sampleWithoutReplacementAggregator(groupVars, weightColumn, k, seed);
        Row[] rows = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groups.as((Encoder)ExpressionEncoder$.MODULE$.apply(schema.apply(groupCols)), (Encoder)ExpressionEncoder$.MODULE$.apply(schema)).agg(sampleAgg.toColumn()).collect())).flatMap((Function1 & Serializable & scala.Serializable)x -> (Seq)((TraversableOnce)x._2()).toSeq().map((Function1 & Serializable & scala.Serializable)s -> s.row(), Seq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        SparkContext qual$1 = df.rdd().context();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])rows);
        int x$2 = qual$1.parallelize$default$2();
        return qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> sampleWithReplacement(Dataset<Row> df, Seq<String> groupVars, String weightColumn, int k, long seed) {
        StructType schema = df.schema();
        RelationalGroupedDataset groups = df.groupBy((Seq)groupVars.map((Function1 & Serializable & scala.Serializable)x -> new Column(x), Seq$.MODULE$.canBuildFrom()));
        Set groupCols = (Set)Predef$.MODULE$.Set().apply(groupVars);
        Aggregator<Row, SamplingUtils.Sample[], SamplingUtils.Sample[]> sampleAgg = this.sampleWithReplacementAggregator(groupVars, weightColumn, k, seed);
        Row[] rows = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groups.as((Encoder)ExpressionEncoder$.MODULE$.apply(schema.apply(groupCols)), (Encoder)ExpressionEncoder$.MODULE$.apply(schema)).agg(sampleAgg.toColumn()).collect())).flatMap((Function1 & Serializable & scala.Serializable)x -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x._2())).map((Function1 & Serializable & scala.Serializable)s -> s.row(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        SparkContext qual$1 = df.rdd().context();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])rows);
        int x$2 = qual$1.parallelize$default$2();
        return qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> sampleFracWithoutReplacement(Dataset<Row> df, Seq<String> groupVars, String weightColumn, double frac, long seed) {
        StructType schema = df.schema();
        RelationalGroupedDataset groups = df.groupBy((Seq)groupVars.map((Function1 & Serializable & scala.Serializable)x -> new Column(x), Seq$.MODULE$.canBuildFrom()));
        Set groupCols = (Set)Predef$.MODULE$.Set().apply(groupVars);
        Aggregator<Row, HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>>, HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>>> sampleAgg = this.sampleFracWithoutReplacementAggregator(df, groupVars, weightColumn, frac, seed);
        Row[] rows = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groups.as((Encoder)ExpressionEncoder$.MODULE$.apply(schema.apply(groupCols)), (Encoder)ExpressionEncoder$.MODULE$.apply(schema)).agg(sampleAgg.toColumn()).collect())).flatMap((Function1 & Serializable & scala.Serializable)x -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((HashMap)x._2()).values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)e -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])e.toArray(ClassTag$.MODULE$.apply(SamplingUtils.Sample.class)))).flatMap((Function1 & Serializable & scala.Serializable)s -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{s.row()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))), Iterable$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        SparkContext qual$1 = df.rdd().context();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])rows);
        int x$2 = qual$1.parallelize$default$2();
        return qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Row.class));
    }

    public RDD<Row> sampleFracWithReplacement(Dataset<Row> df, Seq<String> groupVars, String weightColumn, double frac, long seed) {
        StructType schema = df.schema();
        RelationalGroupedDataset groups = df.groupBy((Seq)groupVars.map((Function1 & Serializable & scala.Serializable)x -> new Column(x), Seq$.MODULE$.canBuildFrom()));
        Set groupCols = (Set)Predef$.MODULE$.Set().apply(groupVars);
        Aggregator<Row, HashMap<List<Object>, SamplingUtils.Sample[]>, HashMap<List<Object>, SamplingUtils.Sample[]>> sampleAgg = this.sampleFracWithReplacementAggregator(df, groupVars, weightColumn, frac, seed);
        Row[] rows = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groups.as((Encoder)ExpressionEncoder$.MODULE$.apply(schema.apply(groupCols)), (Encoder)ExpressionEncoder$.MODULE$.apply(schema)).agg(sampleAgg.toColumn()).collect())).flatMap((Function1 & Serializable & scala.Serializable)x -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((HashMap)x._2()).values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)e -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])e)).flatMap((Function1 & Serializable & scala.Serializable)s -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{s.row()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))), Iterable$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
        SparkContext qual$1 = df.rdd().context();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])rows);
        int x$2 = qual$1.parallelize$default$2();
        return qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Row.class));
    }

    private Aggregator<Row, BoundedPriorityQueue<SamplingUtils.Sample>, BoundedPriorityQueue<SamplingUtils.Sample>> sampleWithoutReplacementAggregator(Seq<String> groupVars, String weightColumn, int k, long seed) {
        return new Aggregator<Row, BoundedPriorityQueue<SamplingUtils.Sample>, BoundedPriorityQueue<SamplingUtils.Sample>>(k, weightColumn, seed, groupVars){
            private final ConcurrentHashMap<Object, Random> prngState;
            private final int k$1;
            private final String weightColumn$1;
            private final long seed$1;
            private final Seq groupVars$1;

            public BoundedPriorityQueue<SamplingUtils.Sample> zero() {
                return new BoundedPriorityQueue<SamplingUtils.Sample>(this.k$1, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            }

            public BoundedPriorityQueue<SamplingUtils.Sample> reduce(BoundedPriorityQueue<SamplingUtils.Sample> b, Row a) {
                BoxedUnit boxedUnit;
                double weight = SamplingUtils$.MODULE$.extractWeightValue(a, this.weightColumn$1);
                if (weight > 0.0) {
                    long sampleSeed = this.seed$1 + (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.groupVars$1.map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToInteger((int)anon.1.$anonfun$reduce$1(a, c)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                    Random random = this.prngState.computeIfAbsent(BoxesRunTime.boxToLong((long)sampleSeed), x -> anon.1.$anonfun$reduce$2(BoxesRunTime.unboxToLong((Object)x)));
                    SamplingUtils.Sample sample = new SamplingUtils.Sample(SamplingUtils$.MODULE$.genSamplePriority(weight, random), a);
                    boxedUnit = b.$plus$eq((Object)sample);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return b;
            }

            public BoundedPriorityQueue<SamplingUtils.Sample> merge(BoundedPriorityQueue<SamplingUtils.Sample> b1, BoundedPriorityQueue<SamplingUtils.Sample> b2) {
                b1.$plus$plus$eq((TraversableOnce)b2);
                return b1;
            }

            public BoundedPriorityQueue<SamplingUtils.Sample> finish(BoundedPriorityQueue<SamplingUtils.Sample> reduction) {
                return reduction;
            }

            public Encoder<BoundedPriorityQueue<SamplingUtils.Sample>> bufferEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(BoundedPriorityQueue.class));
            }

            public Encoder<BoundedPriorityQueue<SamplingUtils.Sample>> outputEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(BoundedPriorityQueue.class));
            }

            public static final /* synthetic */ int $anonfun$reduce$1(Row a$1, String c) {
                return a$1.get(a$1.fieldIndex(c)).hashCode();
            }

            public static final /* synthetic */ Random $anonfun$reduce$2(long x) {
                return new Random(x);
            }
            {
                this.k$1 = k$1;
                this.weightColumn$1 = weightColumn$1;
                this.seed$1 = seed$1;
                this.groupVars$1 = groupVars$1;
                this.prngState = new ConcurrentHashMap<K, V>();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$reduce$1$adapted(org.apache.spark.sql.Row java.lang.String )}, serializedLambda);
            }
        };
    }

    private Aggregator<Row, SamplingUtils.Sample[], SamplingUtils.Sample[]> sampleWithReplacementAggregator(Seq<String> groupVars, String weightColumn, int k, long seed) {
        return new Aggregator<Row, SamplingUtils.Sample[], SamplingUtils.Sample[]>(k, weightColumn, seed, groupVars){
            private final ConcurrentHashMap<Object, Random> prngState;
            private final int k$2;
            private final String weightColumn$2;
            private final long seed$2;
            private final Seq groupVars$2;

            public SamplingUtils.Sample[] zero() {
                return (SamplingUtils.Sample[])Array$.MODULE$.fill(this.k$2, (Function0 & Serializable & scala.Serializable)() -> new SamplingUtils.Sample(Double.NEGATIVE_INFINITY, null), ClassTag$.MODULE$.apply(SamplingUtils.Sample.class));
            }

            public SamplingUtils.Sample[] reduce(SamplingUtils.Sample[] b, Row a) {
                block0: {
                    DoubleRef weight = DoubleRef.create((double)SamplingUtils$.MODULE$.extractWeightValue(a, this.weightColumn$2));
                    if (!(weight.elem > 0.0)) break block0;
                    long sampleSeed = this.seed$2 + (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.groupVars$2.map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToInteger((int)anon.2.$anonfun$reduce$3(a, c)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                    Random random = this.prngState.computeIfAbsent(BoxesRunTime.boxToLong((long)sampleSeed), x -> anon.2.$anonfun$reduce$4(BoxesRunTime.unboxToLong((Object)x)));
                    package$.MODULE$.Range().apply(0, this.k$2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                        block0: {
                            SamplingUtils.Sample replacement = new SamplingUtils.Sample(SamplingUtils$.MODULE$.genSamplePriority(weight$1.elem, random), a);
                            if (!b[idx].$less(replacement)) break block0;
                            b$1[idx] = replacement;
                        }
                    });
                }
                return b;
            }

            public SamplingUtils.Sample[] merge(SamplingUtils.Sample[] b1, SamplingUtils.Sample[] b2) {
                package$.MODULE$.Range().apply(0, this.k$2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                    block0: {
                        if (!b1[idx].$less(b2[idx])) break block0;
                        b1$1[idx] = b2[idx];
                    }
                });
                return b1;
            }

            public SamplingUtils.Sample[] finish(SamplingUtils.Sample[] reduction) {
                return reduction;
            }

            public Encoder<SamplingUtils.Sample[]> bufferEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(SamplingUtils.Sample.class)));
            }

            public Encoder<SamplingUtils.Sample[]> outputEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(SamplingUtils.Sample.class)));
            }

            public static final /* synthetic */ int $anonfun$reduce$3(Row a$2, String c) {
                return a$2.get(a$2.fieldIndex(c)).hashCode();
            }

            public static final /* synthetic */ Random $anonfun$reduce$4(long x) {
                return new Random(x);
            }
            {
                this.k$2 = k$2;
                this.weightColumn$2 = weightColumn$2;
                this.seed$2 = seed$2;
                this.groupVars$2 = groupVars$2;
                this.prngState = new ConcurrentHashMap<K, V>();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$zero$1(), $anonfun$reduce$3$adapted(org.apache.spark.sql.Row java.lang.String ), $anonfun$reduce$5(scala.runtime.DoubleRef scala.util.Random org.apache.spark.sql.Row sparklyr.SamplingUtils$Sample[] int ), $anonfun$merge$1(sparklyr.SamplingUtils$Sample[] sparklyr.SamplingUtils$Sample[] int )}, serializedLambda);
            }
        };
    }

    private Aggregator<Row, HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>>, HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>>> sampleFracWithoutReplacementAggregator(Dataset<Row> df, Seq<String> groupVars, String weightColumn, double frac, long seed) {
        Map<List<Object>, Object> sampleSizes = this.computeStrataSampleSizes(df, groupVars, frac);
        return new Aggregator<Row, HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>>, HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>>>(weightColumn, seed, groupVars, sampleSizes){
            private final ConcurrentHashMap<Object, Random> prngState;
            private final String weightColumn$3;
            private final long seed$3;
            private final Seq groupVars$3;
            private final Map sampleSizes$1;

            public HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>> zero() {
                return new HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>>();
            }

            public HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>> reduce(HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>> b, Row a) {
                block0: {
                    double weight = SamplingUtils$.MODULE$.extractWeightValue(a, this.weightColumn$3);
                    if (!(weight > 0.0)) break block0;
                    long sampleSeed = this.seed$3 + (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.groupVars$3.map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToInteger((int)anon.3.$anonfun$reduce$6(a, c)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                    Random random = this.prngState.computeIfAbsent(BoxesRunTime.boxToLong((long)sampleSeed), x -> anon.3.$anonfun$reduce$7(BoxesRunTime.unboxToLong((Object)x)));
                    SamplingUtils.Sample sample = new SamplingUtils.Sample(SamplingUtils$.MODULE$.genSamplePriority(weight, random), a);
                    this.updateSamplesPQ(sample, b, (Seq<String>)this.groupVars$3, (Map<List<Object>, Object>)this.sampleSizes$1);
                }
                return b;
            }

            public HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>> merge(HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>> b1, HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>> b2) {
                b2.entrySet().stream().forEach(entry -> {
                    BoundedPriorityQueue pq = b1.computeIfAbsent((List<Object>)entry.getKey(), x -> new BoundedPriorityQueue<A>(BoxesRunTime.unboxToInt((Object)$this.sampleSizes$1.get(x).get()), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
                    pq.$plus$plus$eq((TraversableOnce)entry.getValue());
                });
                return b1;
            }

            public HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>> finish(HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>> reduction) {
                return reduction;
            }

            public Encoder<HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>>> bufferEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(HashMap.class));
            }

            public Encoder<HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>>> outputEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(HashMap.class));
            }

            private void updateSamplesPQ(SamplingUtils.Sample sample, HashMap<List<Object>, BoundedPriorityQueue<SamplingUtils.Sample>> samplesPQMap, Seq<String> groupVars, Map<List<Object>, Object> sampleSizes) {
                BoundedPriorityQueue pq = samplesPQMap.computeIfAbsent(StratifiedSamplingUtils$.MODULE$.sparklyr$StratifiedSamplingUtils$$extractGroupKey(sample.row(), groupVars), x -> new BoundedPriorityQueue<A>(BoxesRunTime.unboxToInt((Object)sampleSizes.get(x).get()), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
                pq.$plus$eq(sample);
            }

            public static final /* synthetic */ int $anonfun$reduce$6(Row a$3, String c) {
                return a$3.get(a$3.fieldIndex(c)).hashCode();
            }

            public static final /* synthetic */ Random $anonfun$reduce$7(long x) {
                return new Random(x);
            }
            {
                this.weightColumn$3 = weightColumn$3;
                this.seed$3 = seed$3;
                this.groupVars$3 = groupVars$3;
                this.sampleSizes$1 = sampleSizes$1;
                this.prngState = new ConcurrentHashMap<K, V>();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$reduce$6$adapted(org.apache.spark.sql.Row java.lang.String )}, serializedLambda);
            }
        };
    }

    private Aggregator<Row, HashMap<List<Object>, SamplingUtils.Sample[]>, HashMap<List<Object>, SamplingUtils.Sample[]>> sampleFracWithReplacementAggregator(Dataset<Row> df, Seq<String> groupVars, String weightColumn, double frac, long seed) {
        Map<List<Object>, Object> sampleSizes = this.computeStrataSampleSizes(df, groupVars, frac);
        return new Aggregator<Row, HashMap<List<Object>, SamplingUtils.Sample[]>, HashMap<List<Object>, SamplingUtils.Sample[]>>(weightColumn, seed, groupVars, sampleSizes){
            private final ConcurrentHashMap<Object, Random> prngState;
            private final String weightColumn$4;
            private final long seed$4;
            private final Seq groupVars$4;
            private final Map sampleSizes$3;

            public HashMap<List<Object>, SamplingUtils.Sample[]> zero() {
                return new HashMap<List<Object>, SamplingUtils.Sample[]>();
            }

            public HashMap<List<Object>, SamplingUtils.Sample[]> reduce(HashMap<List<Object>, SamplingUtils.Sample[]> b, Row a) {
                block0: {
                    double weight = SamplingUtils$.MODULE$.extractWeightValue(a, this.weightColumn$4);
                    if (!(weight > 0.0)) break block0;
                    long sampleSeed = this.seed$4 + (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.groupVars$4.map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToInteger((int)anon.4.$anonfun$reduce$8(a, c)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                    Random random = this.prngState.computeIfAbsent(BoxesRunTime.boxToLong((long)sampleSeed), x -> anon.4.$anonfun$reduce$9(BoxesRunTime.unboxToLong((Object)x)));
                    this.updateSamplesArray(random, a, weight, b, (Seq<String>)this.groupVars$4, (Map<List<Object>, Object>)this.sampleSizes$3);
                }
                return b;
            }

            public HashMap<List<Object>, SamplingUtils.Sample[]> merge(HashMap<List<Object>, SamplingUtils.Sample[]> b1, HashMap<List<Object>, SamplingUtils.Sample[]> b2) {
                b2.entrySet().stream().forEach(entry -> {
                    int sampleSize = BoxesRunTime.unboxToInt((Object)$this.sampleSizes$3.get(entry.getKey()).get());
                    SamplingUtils.Sample[] samples = b1.computeIfAbsent((List<Object>)entry.getKey(), x -> (SamplingUtils.Sample[])Array$.MODULE$.fill(sampleSize, (Function0 & Serializable & scala.Serializable)() -> new SamplingUtils.Sample(Double.NEGATIVE_INFINITY, null), ClassTag$.MODULE$.apply(SamplingUtils.Sample.class)));
                    SamplingUtils.Sample[] replacements = (SamplingUtils.Sample[])entry.getValue();
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sampleSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                        block0: {
                            if (!samples[idx].$less(replacements[idx])) break block0;
                            samples$1[idx] = replacements[idx];
                        }
                    });
                });
                return b1;
            }

            public HashMap<List<Object>, SamplingUtils.Sample[]> finish(HashMap<List<Object>, SamplingUtils.Sample[]> reduction) {
                return reduction;
            }

            public Encoder<HashMap<List<Object>, SamplingUtils.Sample[]>> bufferEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(HashMap.class));
            }

            public Encoder<HashMap<List<Object>, SamplingUtils.Sample[]>> outputEncoder() {
                return Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(HashMap.class));
            }

            private void updateSamplesArray(Random random, Row row, double weight, HashMap<List<Object>, SamplingUtils.Sample[]> samplesArrayMap, Seq<String> groupVars, Map<List<Object>, Object> sampleSizes) {
                List<Object> key = StratifiedSamplingUtils$.MODULE$.sparklyr$StratifiedSamplingUtils$$extractGroupKey(row, groupVars);
                int sampleSize = BoxesRunTime.unboxToInt((Object)sampleSizes.get(key).get());
                SamplingUtils.Sample[] samples = samplesArrayMap.computeIfAbsent(key, x -> (SamplingUtils.Sample[])Array$.MODULE$.fill(sampleSize, (Function0 & Serializable & scala.Serializable)() -> new SamplingUtils.Sample(Double.NEGATIVE_INFINITY, null), ClassTag$.MODULE$.apply(SamplingUtils.Sample.class)));
                package$.MODULE$.Range().apply(0, sampleSize).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                    block0: {
                        SamplingUtils.Sample replacement = new SamplingUtils.Sample(SamplingUtils$.MODULE$.genSamplePriority(weight, random), row);
                        if (!samples[idx].$less(replacement)) break block0;
                        samples$2[idx] = replacement;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public static final /* synthetic */ int $anonfun$reduce$8(Row a$4, String c) {
                return a$4.get(a$4.fieldIndex(c)).hashCode();
            }

            public static final /* synthetic */ Random $anonfun$reduce$9(long x) {
                return new Random(x);
            }
            {
                this.weightColumn$4 = weightColumn$4;
                this.seed$4 = seed$4;
                this.groupVars$4 = groupVars$4;
                this.sampleSizes$3 = sampleSizes$3;
                this.prngState = new ConcurrentHashMap<K, V>();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$reduce$8$adapted(org.apache.spark.sql.Row java.lang.String ), $anonfun$updateSamplesArray$3(double scala.util.Random org.apache.spark.sql.Row sparklyr.SamplingUtils$Sample[] int ), $anonfun$merge$6(), $anonfun$merge$7(sparklyr.SamplingUtils$Sample[] sparklyr.SamplingUtils$Sample[] int ), $anonfun$updateSamplesArray$2()}, serializedLambda);
            }
        };
    }

    public List<Object> sparklyr$StratifiedSamplingUtils$$extractGroupKey(Row row, Seq<String> groupVars) {
        return ((TraversableOnce)groupVars.map((Function1 & Serializable & scala.Serializable)c -> row.get(row.fieldIndex(c)), Seq$.MODULE$.canBuildFrom())).toList();
    }

    private Map<List<Object>, Object> computeStrataSampleSizes(Dataset<Row> df, Seq<String> groupVars, double frac) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.groupBy((Seq)groupVars.map((Function1 & Serializable & scala.Serializable)x -> new Column(x), Seq$.MODULE$.canBuildFrom())).count().collect())).map((Function1 & Serializable & scala.Serializable)row -> {
            List<Object> key = MODULE$.sparklyr$StratifiedSamplingUtils$$extractGroupKey((Row)row, groupVars);
            int sampleSize = Predef$.MODULE$.double2Double(Math.ceil((double)row.getLong(groupVars.length()) * frac)).intValue();
            return new Tuple2(key, (Object)BoxesRunTime.boxToInteger((int)sampleSize));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    private StratifiedSamplingUtils$() {
        MODULE$ = this;
    }
}

