% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spareg.R
\name{get_measure}
\alias{get_measure}
\title{Extractor for (cross-)validation measure from '\code{spar}' or '\code{spar.cv}' object}
\usage{
get_measure(object)
}
\arguments{
\item{object}{A fitted '\code{spar}' or '\code{spar.cv}'  model}
}
\value{
data.frame containing the (cross-)validation measure for the considered threshold and number of model combinations.
For '\code{spar}' objects it contains information about the measure  calculated on the validation set (or on the training sample if
xval and yval are missing) and the number of active variables. For '\code{spar.cv}' objects it contains information
on the average measure obtained across folds together with the standard deviation across the folds and the average number of active variables.
the \code{nfolds} of the training set.
}
\description{
Extractor for (cross-)validation measure from '\code{spar}' or '\code{spar.cv}' object
}
\examples{
example_data <- simulate_spareg_data(n = 100, p = 400, ntest = 100)
spar_res <- spar(example_data$x, example_data$y, xval = example_data$xtest,
  yval = example_data$ytest, nummods=c(5, 10, 15, 20, 25, 30))
get_measure(spar_res)

}
\seealso{
\link{spar}, \link{spar.cv}, \link{get_model}
}
