% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gccm.R
\name{gccm}
\alias{gccm}
\alias{gccm,sf-method}
\alias{gccm,SpatRaster-method}
\title{geographical convergent cross mapping}
\usage{
\S4method{gccm}{sf}(
  data,
  cause,
  effect,
  libsizes,
  E = c(3, 3),
  tau = 1,
  k = 4,
  theta = 1,
  algorithm = "simplex",
  pred = NULL,
  nb = NULL,
  threads = detectThreads(),
  bidirectional = TRUE,
  trend.rm = TRUE,
  progressbar = TRUE
)

\S4method{gccm}{SpatRaster}(
  data,
  cause,
  effect,
  libsizes,
  E = c(3, 3),
  tau = 1,
  k = 4,
  theta = 1,
  algorithm = "simplex",
  pred = NULL,
  threads = detectThreads(),
  bidirectional = TRUE,
  trend.rm = TRUE,
  progressbar = TRUE
)
}
\arguments{
\item{data}{The observation data.}

\item{cause}{Name of causal variable.}

\item{effect}{Name of effect variable.}

\item{libsizes}{A vector of library sizes to use.}

\item{E}{(optional) Dimensions of the embedding.}

\item{tau}{(optional) Step of spatial lags.}

\item{k}{(optional) Number of nearest neighbors to use for prediction.}

\item{theta}{(optional) Weighting parameter for distances, useful when \code{algorithm} is \code{smap}.}

\item{algorithm}{(optional) Algorithm used for prediction.}

\item{pred}{pred (optional) Row numbers(\code{vector}) of lattice data or row-column numbers(\code{matrix}) of grid data used for predictions.}

\item{nb}{(optional) The neighbours list.}

\item{threads}{(optional) Number of threads.}

\item{bidirectional}{(optional) whether to identify bidirectional causal associations.}

\item{trend.rm}{(optional) Whether to remove the linear trend.}

\item{progressbar}{(optional) whether to print the progress bar.}
}
\value{
A list.
\describe{
\item{\code{xmap}}{cross mapping prediction results}
\item{\code{varname}}{names of causal and effect variable}
\item{\code{bidirectional}}{whether to identify bidirectional causal associations}
}
}
\description{
geographical convergent cross mapping
}
\examples{
columbus = sf::read_sf(system.file("shapes/columbus.gpkg", package="spData"))
\donttest{
g = gccm(columbus,"HOVAL","CRIME",libsizes = seq(5,40,5),E = c(6,5))
g
plot(g, ylimits = c(0,0.8))
}
}
