% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smap.R
\name{smap}
\alias{smap}
\alias{smap,sf-method}
\alias{smap,SpatRaster-method}
\title{smap forecasting}
\usage{
\S4method{smap}{sf}(
  data,
  target,
  lib,
  pred = lib,
  E = 3,
  tau = 1,
  k = 4,
  theta = c(0, 1e-04, 3e-04, 0.001, 0.003, 0.01, 0.03, 0.1, 0.3, 0.5, 0.75, 1, 1.5, 2, 3,
    4, 6, 8),
  nb = NULL,
  threads = detectThreads()
)

\S4method{smap}{SpatRaster}(
  data,
  target,
  lib,
  pred = lib,
  E = 3,
  tau = 1,
  k = 4,
  theta = c(0, 1e-04, 3e-04, 0.001, 0.003, 0.01, 0.03, 0.1, 0.3, 0.5, 0.75, 1, 1.5, 2, 3,
    4, 6, 8),
  threads = detectThreads()
)
}
\arguments{
\item{data}{The observation data.}

\item{target}{Name of target variable.}

\item{lib}{Row numbers(\code{vector}) of lattice data or row-column numbers(\code{matrix}) of grid data for creating the library from observations.}

\item{pred}{(optional) Row numbers(\code{vector}) of lattice data or row-column numbers(\code{matrix}) of grid data used for predictions.}

\item{E}{(optional) Dimensions of the embedding.}

\item{tau}{(optional) Step of spatial lags.}

\item{k}{(optional) Number of nearest neighbors to use for prediction.}

\item{theta}{(optional) Weighting parameter for distances}

\item{nb}{(optional) The neighbours list.}

\item{threads}{(optional) Number of threads.}
}
\value{
A matrix
}
\description{
smap forecasting
}
\examples{
columbus = sf::read_sf(system.file("shapes/columbus.gpkg", package="spData"))
\donttest{
smap(columbus,target = "INC",lib = 1:49)
}
}
