% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mercator.R
\name{lonlat_to_merc}
\alias{lonlat_to_merc}
\alias{merc_to_lonlat}
\title{Transform between spherical Mercator and longitude/latitude}
\usage{
lonlat_to_merc(ll)

merc_to_lonlat(xy)
}
\arguments{
\item{ll}{matrix of longitude / latitude}

\item{xy}{matrix of x / y Mercator}
}
\value{
matrix of coordinates transformed forward or inverse
}
\description{
Transform between spherical Mercator and longitude/latitude
}
\examples{
uluru_lonlat <- matrix(c(131.0325162,
                         -25.3448562),
                       nrow = 1)

lonlat_to_merc(uluru_lonlat)

uluru_merc <- matrix(c(14586472.958481,
                       -2918162.223463),
                     nrow = 1)

merc_to_lonlat(uluru_merc)
}
