% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{plot.sjSDManova}
\alias{plot.sjSDManova}
\title{Plot anova results}
\usage{
\method{plot}{sjSDManova}(
  x,
  y,
  type = c("McFadden", "Deviance", "Nagelkerke"),
  internal = FALSE,
  add_shared = FALSE,
  cols = c("#7FC97F", "#BEAED4", "#FDC086"),
  alpha = 0.15,
  env_deviance = NULL,
  suppress_plotting = FALSE,
  ...
)
}
\arguments{
\item{x}{anova object from \code{\link{anova.sjSDM}}}

\item{y}{unused argument}

\item{type}{deviance, Nagelkerke or McFadden R-squared}

\item{internal}{logical, plot internal or total structure}

\item{add_shared}{Add shared contributions when plotting the internal structure}

\item{cols}{colors for the groups}

\item{alpha}{alpha for colors}

\item{env_deviance}{environmental deviance}

\item{suppress_plotting}{return plots but don't plot them}

\item{...}{Additional arguments to pass to \code{plot()}

The \code{internal = TRUE} plot was heavily inspired by Leibold et al., 2022}
}
\value{
List with the following components:

If \code{internal=TRUE}:

\item{plots}{ggplot objects for sites and species.}
\item{data}{List of data.frames with the shown results.}

else:
\item{VENN}{Matrix of shown results.}
}
\description{
Plot anova results
}
\references{
Leibold, M. A., Rudolph, F. J., Blanchet, F. G., De Meester, L., Gravel, D., Hartig, F., ... & Chase, J. M. (2022). The internal structure of metacommunities. Oikos, 2022(1).
}
