% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_grid.R
\name{plot_grid}
\alias{plot_grid}
\title{Arrange list of plots as grid}
\usage{
plot_grid(x, margin = c(1, 1, 1, 1))
}
\arguments{
\item{x}{A list of ggplot-objects. See 'Details'.}

\item{margin}{A numeric vector of length 4, indicating the top, right, bottom
and left margin for each plot, in centimetres.}
}
\value{
An object of class \code{gtable}.
}
\description{
Plot multiple ggplot-objects as a grid-arranged single plot.
}
\details{
This function takes a \code{list} of ggplot-objects as argument.
         Plotting functions of this package that produce multiple plot
         objects (e.g., when there is an argument \code{facet.grid}) usually
         return multiple plots as list (the return value is named \code{plot.list}).
         To arrange these plots as grid as a single plot, use \code{plot_grid}.
}
\examples{
library(sjmisc)
data(efc)
# fit model
fit <- lm(tot_sc_e ~ c12hour + e17age + e42dep + neg_c_7, data = efc)
# plot marginal effects for each predictor, each as single plot
p <- sjp.lm(fit, type = "eff", facet.grid = FALSE, prnt.plot = FALSE)

# plot grid
plot_grid(p$plot.list)

# or
plot_grid(p)

}
