% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{silv_basal_area}
\alias{silv_basal_area}
\title{Calculates Basal Area}
\usage{
silv_basal_area(diameter, ntrees = NULL, units = "cm")
}
\arguments{
\item{diameter}{Numeric vector of diameters or diameter classes}

\item{ntrees}{Numeric vector with number of trees of the diameter class per
hectare. If \code{ntrees = NULL}, the function will assume that each diameter
corresponds to only one tree. Therefore, basal area will be calculated
for each individual tree}

\item{units}{The units of the diameter (one of \code{cm}, \code{mm}, or \code{m})}
}
\value{
A numeric vector
}
\description{
Calculates Basal Area in square meters.
}
\details{
The function uses the next formula:

\eqn{G = \frac{\pi}{40000} \cdot D^2}

where G is the basal area in \eqn{m^2}, and D is the diameter in the \code{units}
specified in the function. It is recommended to use the squared mean diameter
calculated with \link{silv_sqrmean_diameter}
}
\examples{
## calculate G for inventory data grouped by plot_id and species
library(dplyr)
inventory_samples |>
mutate(dclass = silv_diametric_class(diameter)) |>
  summarise(
    height = mean(height, na.rm = TRUE),
    ntrees = n(),
    .by    = c(plot_id, species, dclass)
  ) |>
  mutate(
    ntrees_ha = silv_ntrees_ha(ntrees, plot_size = 10),
    dg        = silv_sqrmean_diameter(dclass, ntrees_ha),
    g         = silv_basal_area(dclass, ntrees_ha),
    .by       = c(plot_id, species)
  )

## calculate individual basal area
silv_basal_area(c(23, 11, 43.5, 94))
}
