% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moors_lss.R
\name{moors_lss}
\alias{moors_lss}
\title{Measures of location, scale, and shape based on quantile measures for a generalized log-gamma distribution}
\usage{
moors_lss(mu = 0, sigma = 1, lambda = 1)
}
\arguments{
\item{mu}{numeric, represents the location parameter of a generalized log-gamma distribution. Default value is 0.}

\item{sigma}{numeric, represents the scale parameter of a generalized log-gamma distribution. Default value is 1.}

\item{lambda}{numeric, represents the shape parameter of a generalized log-gamma distribution. Default value is 1.}
}
\description{
\code{moors_lss} is used to obtain the median, the half interquartile range and the quantile coefficient of skewness and kurtosis for a generalized log-gamma distribution.
}
\examples{
moors_lss(mu = 0,sigma = 1,lambda = -1)    # Extreme value type I distribution, maximum case.
moors_lss(mu = 0,sigma = 1,lambda = 1)     # Extreme value type I distribution, minimum case.
moors_lss(mu = 0,sigma = 1,lambda = 0.05) # Standard normal distribution.
}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph. D. thesis. Sao Paulo University.

J. J. A. Moors (1988), A quantile alternative for kurtosis. The Statistician.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
