% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfnetwork.R
\name{sfnetwork}
\alias{sfnetwork}
\title{Create a sfnetwork}
\usage{
sfnetwork(
  nodes,
  edges = NULL,
  directed = TRUE,
  node_key = "name",
  edges_as_lines = NULL,
  length_as_weight = FALSE,
  force = FALSE,
  ...
)
}
\arguments{
\item{nodes}{The nodes of the network. Should be an object of class
\code{\link[sf]{sf}}, or directly convertible to it using
\code{\link[sf]{st_as_sf}}. All features should have an associated geometry
of type \code{POINT}.}

\item{edges}{The edges of the network. May be an object of class
\code{\link[sf]{sf}}, with all features having an associated geometry of
type \code{LINESTRING}. It may also be a regular \code{\link{data.frame}} or
\code{\link[tibble]{tbl_df}} object. In any case, the nodes at the ends of
each edge must either be encoded in a \code{to} and \code{from} column, as
integers or characters. Integers should refer to the position of a node in
the nodes table, while characters should refer to the name of a node encoded
in the column referred to in the \code{node_key} argument. Setting edges to
\code{NULL} will create a network without edges.}

\item{directed}{Should the constructed network be directed? Defaults to
\code{TRUE}.}

\item{node_key}{The name of the column in the nodes table that character
represented \code{to} and \code{from} columns should be matched against. If
\code{NA}, the first column is always chosen. This setting has no effect if
\code{to} and \code{from} are given as integers. Defaults to \code{'name'}.}

\item{edges_as_lines}{Should the edges be spatially explicit, i.e. have
\code{LINESTRING} geometries stored in a geometry list column? If
\code{NULL}, this will be automatically defined, by setting the argument to
\code{TRUE} when the edges are given as an object of class
\code{\link[sf]{sf}}, and \code{FALSE} otherwise. Defaults to \code{NULL}.}

\item{length_as_weight}{Should the length of the edges be stored in a column
named \code{weight}? If set to \code{TRUE}, this will calculate the length
of the linestring geometry of the edge in the case of spatially explicit
edges, and the straight-line distance between the source and target node in
the case of spatially implicit edges. If there is already a column named
\code{weight}, it will be overwritten. Defaults to \code{FALSE}.}

\item{force}{Should network validity checks be skipped? Defaults to
\code{FALSE}, meaning that network validity checks are executed when
constructing the network. These checks guarantee a valid spatial network
structure. For the nodes, this means that they all should have \code{POINT}
geometries. In the case of spatially explicit edges, it is also checked that
all edges have \code{LINESTRING} geometries, nodes and edges have the same
CRS and boundary points of edges match their corresponding node coordinates.
These checks are important, but also time consuming. If you are already sure
your input data meet the requirements, the checks are unnecessary and can be
turned off to improve performance.}

\item{...}{Arguments passed on to \code{\link[sf]{st_as_sf}}, if nodes need
to be converted into an \code{\link[sf]{sf}} object during construction.}
}
\value{
An object of class \code{sfnetwork}.
}
\description{
\code{sfnetwork} is a tidy data structure for geospatial networks. It
extends the \code{\link[tidygraph]{tbl_graph}} data structure for
relational data into the domain of geospatial networks, with nodes and
edges embedded in geographical space, and offers smooth integration with
\code{\link[sf]{sf}} for spatial data analysis.
}
\examples{
library(sf, quietly = TRUE)

## Create sfnetwork from sf objects
p1 = st_point(c(7, 51))
p2 = st_point(c(7, 52))
p3 = st_point(c(8, 52))
nodes = st_as_sf(st_sfc(p1, p2, p3, crs = 4326))

e1 = st_cast(st_union(p1, p2), "LINESTRING")
e2 = st_cast(st_union(p1, p3), "LINESTRING")
e3 = st_cast(st_union(p3, p2), "LINESTRING")
edges = st_as_sf(st_sfc(e1, e2, e3, crs = 4326))
edges$from = c(1, 1, 3)
edges$to = c(2, 3, 2)

# Default.
sfnetwork(nodes, edges)

# Undirected network.
sfnetwork(nodes, edges, directed = FALSE)

# Using character encoded from and to columns.
nodes$name = c("city", "village", "farm")
edges$from = c("city", "city", "farm")
edges$to = c("village", "farm", "village")
sfnetwork(nodes, edges, node_key = "name")

# Spatially implicit edges.
sfnetwork(nodes, edges, edges_as_lines = FALSE)

# Store edge lenghts in a weight column.
sfnetwork(nodes, edges, length_as_weight = TRUE)

}
