% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_gdal.R
\name{check_gdal}
\alias{check_gdal}
\title{Check GDAL installation}
\usage{
check_gdal(abort = TRUE, gdal_path = NULL, force = FALSE, full_scan = FALSE)
}
\arguments{
\item{abort}{Logical parameter: if TRUE (default), the function aborts
in case no GDAL installation is found; if FALSE, a warning is shown
and FALSE is returned.}

\item{gdal_path}{(optional) Character: the path in which GDAL must be
searched in. If NULL (default), search is performed in the whole file system.}

\item{force}{(optional) Logical: if TRUE, install even if it is already
installed (default is FALSE). Notice that, defining \code{gdal_path}, GDAL is
searched again even if \code{"force" = FALSE} in case the existing installation
is not in \code{gdal_path}.}

\item{full_scan}{(optional) Logical: in Linux and MacOS, if \code{gdal_path} was
not manually defined, GDAL is searched within the system path in case this
argument is left to default value FALSE; instead, if TRUE, a full search is
performed. In Windows, if the default OSGeo directory \verb{C:\\\\OSGeo4W64} exists,
GDAL is searched there, otherwise in the main directory \verb{C:\\\\}; setting
\code{full_scan} to TRUE, is is always searched in the whole \verb{C:\\\\}.
This argument takes no effect if \code{gdal_path} was defined, since, in that case,
a full search is always performed in \code{gdal_path}.}
}
\value{
Logical (invisible): TRUE in case the installation is ok, FALSE
if GDAL is missing and abort=FALSE (otherwise, the function stops).
}
\description{
The function checks that GDAL is installed and updated to
the minimum required version (2.1.2).
}
\note{
License: GPL 3.0
}
\examples{
\dontrun{
check_gdal()
}
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
