% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_abs2rel.R
\name{gdal_abs2rel}
\alias{gdal_abs2rel}
\alias{gdal_rel2abs}
\title{Convert absolute from/to relative paths in a virtual file}
\usage{
gdal_abs2rel(in_vrt, out_vrt = NA)

gdal_rel2abs(in_vrt, out_vrt = NA)
}
\arguments{
\item{in_vrt}{The path of the VRT to be read.}

\item{out_vrt}{(optional) The path of the output VRT file (default
is to overwrite \code{in_vrt}).}
}
\value{
NULL (the function is called for its side effects)
}
\description{
The two functions read the content of a GDAL virtual
file (VRT) and check the presence of paths to linked files.

\link{gdal_abs2rel} scans the presence of absolute paths: when an
absolute path has a common parent directory with the path in which
the VRT is, this is replaced with a relative. This is useful when
VRT are on a remote driver, which can be mounted to several points.

\link{gdal_rel2abs} checks the presence of relative paths,
and replace them with the corresponding absolute path (symbolic
links are followed). This is useful to grant that VRT can be moved
(if the files they link to are not moved).
}
\note{
License: GPL 3.0
}
\examples{
# Load a VRT containing a relative path
ex_vrt <- system.file(
  "extdata/out/S2A2A_20190723_022_Barbellino_RGB432B_10.vrt", 
  package = "sen2r"
)
abs_vrt <- tempfile(fileext = "_abs.vrt")
rel_vrt <- tempfile(fileext = "_rel.vrt")
gdal_rel2abs(ex_vrt, abs_vrt)
gdal_abs2rel(ex_vrt, rel_vrt)

# Show differences
ex_vrt_content <- readLines(ex_vrt)
abs_vrt_content <- readLines(abs_vrt)
rel_vrt_content <- readLines(rel_vrt)
ex_vrt_content[ex_vrt_content != abs_vrt_content] # Original line
abs_vrt_content[ex_vrt_content != abs_vrt_content] # Modified line
rel_vrt_content[ex_vrt_content != rel_vrt_content] # No edits
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
