% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_path.R
\name{expand_path}
\alias{expand_path}
\title{Expand a path with a parent directory}
\usage{
expand_path(path, parent = getwd(), silent = TRUE, normalize = TRUE)
}
\arguments{
\item{path}{The path name (\code{character}) to check ad eventually expand.}

\item{parent}{The parent directory (\code{character}) to use if \code{path} is
relative (default value: the working directory).}

\item{silent}{Logical value: if TRUE (default), no message are shown;
if FALSE, a message inform if \code{parent} were applied or not;
if NA, a warning is returned if \code{path} is expanded, nothing if it
is already an absolute path.}

\item{normalize}{Logical value: if TRUE (default), the path is normalised
(\code{\link[base]{normalizePath}} is applied); if FALSE it is simply
appended.}

\item{...}{\code{R} objects which are concatenated.}
}
\value{
The path eventually expanded.
}
\description{
Accessory function which checks if a path is absolute or relative;
if relative, use a specified parent directory instead than the working
directory to expand it.
Useful for functions which accept more than one path as arguments,
in which one of them contains the absolute position, and the others
do not.
}
\note{
License: GPL 3.0
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
