% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates_secuTrial.R
\name{dates_secuTrial}
\alias{dates_secuTrial}
\alias{dates_secuTrial.secuTrialdata}
\title{Methods to handle date(times)s in secuTrial exports}
\usage{
dates_secuTrial(object, ...)

\method{dates_secuTrial}{secuTrialdata}(object, ...)
}
\arguments{
\item{object}{\code{secuTrialdata} object}

\item{...}{further parameters}
}
\value{
same as the original object with date variables converted to \code{Date}s.
}
\description{
Converts dates and datetime variables to \code{Date} or \code{POSIXct} class, as appropriate.
}
\details{
New variables are created appended with \code{.date} or \code{.datetime}.
         This is a safety mechanism in case NAs are inadvertently introduced.
}
\examples{
# prepare path to example export
export_location <- system.file("extdata", "sT_exports", "lnames",
                               "s_export_CSV-xls_CTU05_long_ref_miss_en_utf8.zip",
                               package = "secuTrialR")
# load all export data
sT_export <- read_secuTrial_raw(data_dir = export_location)
# prepare dates
sT_export_dates <- dates_secuTrial(sT_export)

# show parsed datetime example
sT_export_dates$ctu05baseline$hiv_date.datetime[1]
# [1] "2019-03-05 23:56:00 CET"
# show parsed date example
sT_export_dates$ctu05baseline$paracetamol_start.date[1]
# [1] "2019-03-05"
}
