% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_CART.R
\name{gen_cart}
\alias{gen_cart}
\title{Generate synthetic data using CART.}
\usage{
gen_cart(training_set, structure = NA)
}
\arguments{
\item{training_set}{A data frame of the training data. The generated data will
have the same size as the \code{training_set}.}

\item{structure}{A string of the relationships between variables from
\code{\link[bnlearn:model string utilities]{modelstring}}. If structure is NA,
the default structure would be the sequence of the variables in the \code{training_set}
data frame.}
}
\value{
The output is a list of three objects: i) structure: the dependency/relationship
between the variables (a \code{\link[bnlearn:bn class]{bn-class}} object); ii) fit_model:
the fitted CART model ((a \code{\link[synthpop:syn]{syn}}) object and iii) gen_data:
the generated synthetic data.
}
\description{
\code{gen_cart} uses Classification and Regression Trees (CART)
to generate synthetic data by sequentially predicting the value of
each variable depending on the value of other variables. Details can
be found in \code{\link[synthpop:syn]{syn}}.
}
\examples{
adult_data <- split_data(adult[1:100,], 70)
cart <- gen_cart(adult_data$training_set)
bn_structure <- "[native_country][income][age|marital_status:education]"
bn_structure = paste0(bn_structure, "[sex][race|native_country][marital_status|race:sex]")
bn_structure = paste0(bn_structure,"[relationship|marital_status][education|sex:race]")
bn_structure = paste0(bn_structure,"[occupation|education][workclass|occupation]")
bn_structure = paste0(bn_structure,"[hours_per_week|occupation:workclass]")
bn_structure = paste0(bn_structure,"[capital_gain|occupation:workclass:income]")
bn_structure = paste0(bn_structure,"[capital_loss|occupation:workclass:income]")
cart_elicit <- gen_cart(adult_data$training_set, bn_structure)

}
