% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{matMatch}
\alias{matMatch}
\title{Matching of matrices}
\usage{
matMatch(x, mat, rows = TRUE, useMatch = FALSE, ...)
}
\arguments{
\item{x}{matrix with the values to be matched.}

\item{mat}{matrix with the values to be matched against.}

\item{rows}{whether the match should be done by rows (\code{TRUE}) or
columns (\code{FALSE}).}

\item{useMatch}{whether to rely on \code{\link[base]{match}} or not. Might
give unexpected mismatches due to working with lists.}

\item{...}{further parameters passed to \code{\link[base]{match}}.}
}
\value{
An integer vector of length \code{nrow(x)} (or \code{ncol(x)})
giving the row (or col) position in table of the first match, if there is
a match.
}
\description{
Wrapper for matching a matrix against another, by rows or
columns.
}
\examples{
# By rows
A <- rbind(5:6, repRow(1:2, 3), 3:4)
B <- unique(A)
ind <- matMatch(x = A, mat = B)
A
B[ind, ]

# By columns
A <- cbind(5:6, repCol(1:2, 3), 3:4)
B <- t(unique(t(A)))
ind <- matMatch(x = A, mat = B, rows = FALSE)
A
B[, ind]
}
\keyword{internal}
