% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin}
\alias{woebin}
\title{WOE Binning}
\usage{
woebin(dt, y, x = NULL, breaks_list = NULL, min_perc_total = 0.02,
  stop_limit = 0.1, max_bin_num = 5, positive = "bad|1", order = FALSE,
  print_step = 1L)
}
\arguments{
\item{dt}{A data frame with both x (predictor/feature) and y (response/label) variables.}

\item{y}{Name of y variable.}

\item{x}{Name of x variables. Default NULL If x is NULL, all variables exclude y will counted as x variables.}

\item{breaks_list}{List of break points, defaults NULL If it is not NULL, variable binning will based on the provided breaks.}

\item{min_perc_total}{The share of initial binning class number over total. Accepted range: 0.01-0.2; default 0.02.}

\item{stop_limit}{Stop binning segmentation when information value gain ratio less than the stop_limit. Accepted range: 0-0.5; default 0.1.}

\item{max_bin_num}{Integer. The maximum binning number.}

\item{positive}{Value of positive class, default "bad|1".}

\item{order}{Logical. If it is TRUE, return binning information by descending sorted iv values.}

\item{print_step}{A non-negative integer. Default is 1. Print variable names by print_step when print_step>0. If print_step=0, no message is printed.}
}
\value{
Optimal or customized binning information
}
\description{
\code{woebin} generates optimal binning for both numerical and categorical variables using tree-like segmentation. For the categorical variables, the binning segmentation will ordered by the levels for factor and by the bad probability for character. \code{woebin} can also customizing breakpoints for both numerical and categorical variables.
}
\examples{
# load germancredit data
data(germancredit)

# Example I
# binning for two variables in germancredit dataset
bins_2var <- woebin(germancredit, y = "creditability", x = c("credit.amount", "purpose"))

\dontrun{
# Example II
# binning for germancredit dataset
bins_germ <- woebin(germancredit, y = "creditability")

# Example III
# customizing stop_limit (info-value grain ratio) for each variable
bins_cus_sl <- woebin(germancredit, y="creditability",
  x=c("age.in.years", "credit.amount", "housing", "purpose"),
  stop_limit=c(0.05,0.1,0.01,0.1))

# Example IV
# customizing the breakpoints of binning
breaks_list <- list(
  age.in.years = c(25, 35, 40, 60),
  credit.amount = NULL,
  housing = c("own", "for free\%,\%rent"),
  purpose = NULL
)

bins_cus_brk <- woebin(germancredit, y="creditability",
  x=c("age.in.years", "credit.amount", "housing", "purpose"),
  breaks_list=breaks_list)
}

}
\seealso{
\code{\link{woebin_ply}}, \code{\link{woebin_plot}}
}
