% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-date.R
\name{label_date}
\alias{label_date}
\alias{label_date_short}
\alias{label_time}
\alias{date_format}
\alias{time_format}
\title{Label date/times}
\usage{
label_date(format = "\%Y-\%m-\%d", tz = "UTC")

label_date_short(format = c("\%Y", "\%b", "\%d", "\%H:\%M"),
  sep = "\\n")

label_time(format = "\%H:\%M:\%S", tz = "UTC")

date_format(format = "\%Y-\%m-\%d", tz = "UTC")

time_format(format = "\%H:\%M:\%S", tz = "UTC")
}
\arguments{
\item{format}{For \code{date_format()} and \code{time_format()} a date/time format
string using standard POSIX specification.  See \code{\link[=strptime]{strptime()}} for details.

For \code{date_short()} a character vector of length 4 giving the format
components to use for year, month, day, and hour respectively.}

\item{tz}{a time zone name, see \code{\link[=timezones]{timezones()}}. Defaults
to UTC}

\item{sep}{Separator to use when combining date formats into a single string.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
\code{label_date()} and \code{label_time()} label date/times using date/time format
strings. \code{label_date_short()} automatically constructs a short format string
suffiicient to uniquely identify labels. It's inspired by matplotlib's
\href{https://matplotlib.org/api/dates_api.html#matplotlib.dates.ConciseDateFormatter}{ConciseDateFormatter},
but uses a slightly different approach: \code{ConciseDateFormatter} formats
"firsts" (e.g. first day of month, first day of day) specially;
\code{date_short()} formats changes (e.g. new month, new year) specially.
}
\section{Old interface}{

\code{date_format()} and \code{time_format()} are retired; please use \code{label_date()}
and \code{label_time()} instead.
}

\examples{
date_range <- function(start, days) {
  start <- as.POSIXct(start)
  c(start, start + days * 24 * 60 * 60)
}

two_months <- date_range("2020-05-01", 60)
demo_datetime(two_months)
demo_datetime(two_months, labels = date_format("\%m/\%d"))
# ggplot2 provides a short-hand:
demo_datetime(two_months, date_labels = "\%m/\%d")

# An alternative labelling system is label_date_short()
demo_datetime(two_months, date_breaks = "7 days", labels = label_date_short())
# This is particularly effective for dense labels
one_year <- date_range("2020-05-01", 365)
demo_datetime(one_year, date_breaks = "month")
demo_datetime(one_year, date_breaks = "month", labels = label_date_short())
}
